/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelAllocationTaskParameters
implements JsonpSerializable {
    private final int modelBytes;
    private final String modelId;
    public static final JsonpDeserializer<TrainedModelAllocationTaskParameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelAllocationTaskParameters::setupTrainedModelAllocationTaskParametersDeserializer);

    private TrainedModelAllocationTaskParameters(Builder builder) {
        this.modelBytes = ApiTypeHelper.requireNonNull(builder.modelBytes, this, "modelBytes");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
    }

    public static TrainedModelAllocationTaskParameters of(Function<Builder, ObjectBuilder<TrainedModelAllocationTaskParameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int modelBytes() {
        return this.modelBytes;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_bytes");
        generator.write(this.modelBytes);
        generator.writeKey("model_id");
        generator.write(this.modelId);
    }

    protected static void setupTrainedModelAllocationTaskParametersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelBytes, JsonpDeserializer.integerDeserializer(), "model_bytes");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TrainedModelAllocationTaskParameters> {
        private Integer modelBytes;
        private String modelId;

        public final Builder modelBytes(int value) {
            this.modelBytes = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        @Override
        public TrainedModelAllocationTaskParameters build() {
            this._checkSingleUse();
            return new TrainedModelAllocationTaskParameters(this);
        }
    }
}

