/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich.stats;

import co.elastic.clients.elasticsearch.tasks.TaskInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ExecutingPolicy
implements JsonpSerializable {
    private final String name;
    private final TaskInfo task;
    public static final JsonpDeserializer<ExecutingPolicy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutingPolicy::setupExecutingPolicyDeserializer);

    private ExecutingPolicy(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.task = ApiTypeHelper.requireNonNull(builder.task, this, "task");
    }

    public static ExecutingPolicy of(Function<Builder, ObjectBuilder<ExecutingPolicy>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final TaskInfo task() {
        return this.task;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("task");
        this.task.serialize(generator, mapper);
    }

    protected static void setupExecutingPolicyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::task, TaskInfo._DESERIALIZER, "task");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ExecutingPolicy> {
        private String name;
        private TaskInfo task;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder task(TaskInfo value) {
            this.task = value;
            return this;
        }

        public final Builder task(Function<TaskInfo.Builder, ObjectBuilder<TaskInfo>> fn) {
            return this.task(fn.apply(new TaskInfo.Builder()).build());
        }

        @Override
        public ExecutingPolicy build() {
            this._checkSingleUse();
            return new ExecutingPolicy(this);
        }
    }
}

