/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.async_search;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class AsyncSearchResponseBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    private final boolean isPartial;
    private final boolean isRunning;
    private final DateTime expirationTimeInMillis;
    private final DateTime startTimeInMillis;

    protected AsyncSearchResponseBase(AbstractBuilder<?> builder) {
        this.id = ((AbstractBuilder)builder).id;
        this.isPartial = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).isPartial, this, "isPartial");
        this.isRunning = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).isRunning, this, "isRunning");
        this.expirationTimeInMillis = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).expirationTimeInMillis, this, "expirationTimeInMillis");
        this.startTimeInMillis = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).startTimeInMillis, this, "startTimeInMillis");
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final boolean isPartial() {
        return this.isPartial;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final DateTime expirationTimeInMillis() {
        return this.expirationTimeInMillis;
    }

    public final DateTime startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        generator.writeKey("is_partial");
        generator.write(this.isPartial);
        generator.writeKey("is_running");
        generator.write(this.isRunning);
        generator.writeKey("expiration_time_in_millis");
        this.expirationTimeInMillis.serialize(generator, mapper);
        generator.writeKey("start_time_in_millis");
        this.startTimeInMillis.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAsyncSearchResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(AbstractBuilder::isPartial, JsonpDeserializer.booleanDeserializer(), "is_partial");
        op.add(AbstractBuilder::isRunning, JsonpDeserializer.booleanDeserializer(), "is_running");
        op.add(AbstractBuilder::expirationTimeInMillis, DateTime._DESERIALIZER, "expiration_time_in_millis");
        op.add(AbstractBuilder::startTimeInMillis, DateTime._DESERIALIZER, "start_time_in_millis");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private String id;
        private Boolean isPartial;
        private Boolean isRunning;
        private DateTime expirationTimeInMillis;
        private DateTime startTimeInMillis;

        protected AbstractBuilder() {
        }

        public final BuilderT id(@Nullable String value) {
            this.id = value;
            return this.self();
        }

        public final BuilderT isPartial(boolean value) {
            this.isPartial = value;
            return this.self();
        }

        public final BuilderT isRunning(boolean value) {
            this.isRunning = value;
            return this.self();
        }

        public final BuilderT expirationTimeInMillis(DateTime value) {
            this.expirationTimeInMillis = value;
            return this.self();
        }

        public final BuilderT startTimeInMillis(DateTime value) {
            this.startTimeInMillis = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

