/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Watch;
import co.elastic.clients.elasticsearch.watcher.WatchStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryWatch
implements JsonpSerializable {
    private final String id;
    @Nullable
    private final WatchStatus status;
    @Nullable
    private final Watch watch;
    @Nullable
    private final Integer primaryTerm;
    @Nullable
    private final Long seqNo;
    public static final JsonpDeserializer<QueryWatch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryWatch::setupQueryWatchDeserializer);

    private QueryWatch(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.status = builder.status;
        this.watch = builder.watch;
        this.primaryTerm = builder.primaryTerm;
        this.seqNo = builder.seqNo;
    }

    public static QueryWatch of(Function<Builder, ObjectBuilder<QueryWatch>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final WatchStatus status() {
        return this.status;
    }

    @Nullable
    public final Watch watch() {
        return this.watch;
    }

    @Nullable
    public final Integer primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public final Long seqNo() {
        return this.seqNo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        if (this.watch != null) {
            generator.writeKey("watch");
            this.watch.serialize(generator, mapper);
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.intValue());
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.longValue());
        }
    }

    protected static void setupQueryWatchDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::status, WatchStatus._DESERIALIZER, "status");
        op.add(Builder::watch, Watch._DESERIALIZER, "watch");
        op.add(Builder::primaryTerm, JsonpDeserializer.integerDeserializer(), "_primary_term");
        op.add(Builder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<QueryWatch> {
        private String id;
        @Nullable
        private WatchStatus status;
        @Nullable
        private Watch watch;
        @Nullable
        private Integer primaryTerm;
        @Nullable
        private Long seqNo;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder status(@Nullable WatchStatus value) {
            this.status = value;
            return this;
        }

        public final Builder status(Function<WatchStatus.Builder, ObjectBuilder<WatchStatus>> fn) {
            return this.status(fn.apply(new WatchStatus.Builder()).build());
        }

        public final Builder watch(@Nullable Watch value) {
            this.watch = value;
            return this;
        }

        public final Builder watch(Function<Watch.Builder, ObjectBuilder<Watch>> fn) {
            return this.watch(fn.apply(new Watch.Builder()).build());
        }

        public final Builder primaryTerm(@Nullable Integer value) {
            this.primaryTerm = value;
            return this;
        }

        public final Builder seqNo(@Nullable Long value) {
            this.seqNo = value;
            return this;
        }

        @Override
        public QueryWatch build() {
            this._checkSingleUse();
            return new QueryWatch(this);
        }
    }
}

