/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.AnalysisConfig;
import co.elastic.clients.elasticsearch.ml.AnalysisLimits;
import co.elastic.clients.elasticsearch.ml.DataDescription;
import co.elastic.clients.elasticsearch.ml.DatafeedConfig;
import co.elastic.clients.elasticsearch.ml.ModelPlotConfig;
import co.elastic.clients.elasticsearch.ml.PutJobResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutJobRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowLazyOpen;
    private final AnalysisConfig analysisConfig;
    @Nullable
    private final AnalysisLimits analysisLimits;
    private final Time backgroundPersistInterval;
    @Nullable
    private final JsonData customSettings;
    @Nullable
    private final Long dailyModelSnapshotRetentionAfterDays;
    private final DataDescription dataDescription;
    @Nullable
    private final DatafeedConfig datafeedConfig;
    @Nullable
    private final String description;
    private final List<String> groups;
    private final String jobId;
    @Nullable
    private final ModelPlotConfig modelPlotConfig;
    @Nullable
    private final Long modelSnapshotRetentionDays;
    @Nullable
    private final Long renormalizationWindowDays;
    @Nullable
    private final String resultsIndexName;
    @Nullable
    private final Long resultsRetentionDays;
    public static final JsonpDeserializer<PutJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutJobRequest::setupPutJobRequestDeserializer);
    public static final Endpoint<PutJobRequest, PutJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutJobRequest, PutJobResponse>("es/ml.put_job", request -> "PUT", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutJobResponse._DESERIALIZER);

    private PutJobRequest(Builder builder) {
        this.allowLazyOpen = builder.allowLazyOpen;
        this.analysisConfig = ApiTypeHelper.requireNonNull(builder.analysisConfig, this, "analysisConfig");
        this.analysisLimits = builder.analysisLimits;
        this.backgroundPersistInterval = ApiTypeHelper.requireNonNull(builder.backgroundPersistInterval, this, "backgroundPersistInterval");
        this.customSettings = builder.customSettings;
        this.dailyModelSnapshotRetentionAfterDays = builder.dailyModelSnapshotRetentionAfterDays;
        this.dataDescription = ApiTypeHelper.requireNonNull(builder.dataDescription, this, "dataDescription");
        this.datafeedConfig = builder.datafeedConfig;
        this.description = builder.description;
        this.groups = ApiTypeHelper.unmodifiable(builder.groups);
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.modelPlotConfig = builder.modelPlotConfig;
        this.modelSnapshotRetentionDays = builder.modelSnapshotRetentionDays;
        this.renormalizationWindowDays = builder.renormalizationWindowDays;
        this.resultsIndexName = builder.resultsIndexName;
        this.resultsRetentionDays = builder.resultsRetentionDays;
    }

    public static PutJobRequest of(Function<Builder, ObjectBuilder<PutJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowLazyOpen() {
        return this.allowLazyOpen;
    }

    public final AnalysisConfig analysisConfig() {
        return this.analysisConfig;
    }

    @Nullable
    public final AnalysisLimits analysisLimits() {
        return this.analysisLimits;
    }

    public final Time backgroundPersistInterval() {
        return this.backgroundPersistInterval;
    }

    @Nullable
    public final JsonData customSettings() {
        return this.customSettings;
    }

    @Nullable
    public final Long dailyModelSnapshotRetentionAfterDays() {
        return this.dailyModelSnapshotRetentionAfterDays;
    }

    public final DataDescription dataDescription() {
        return this.dataDescription;
    }

    @Nullable
    public final DatafeedConfig datafeedConfig() {
        return this.datafeedConfig;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final List<String> groups() {
        return this.groups;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final ModelPlotConfig modelPlotConfig() {
        return this.modelPlotConfig;
    }

    @Nullable
    public final Long modelSnapshotRetentionDays() {
        return this.modelSnapshotRetentionDays;
    }

    @Nullable
    public final Long renormalizationWindowDays() {
        return this.renormalizationWindowDays;
    }

    @Nullable
    public final String resultsIndexName() {
        return this.resultsIndexName;
    }

    @Nullable
    public final Long resultsRetentionDays() {
        return this.resultsRetentionDays;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowLazyOpen != null) {
            generator.writeKey("allow_lazy_open");
            generator.write(this.allowLazyOpen.booleanValue());
        }
        generator.writeKey("analysis_config");
        this.analysisConfig.serialize(generator, mapper);
        if (this.analysisLimits != null) {
            generator.writeKey("analysis_limits");
            this.analysisLimits.serialize(generator, mapper);
        }
        generator.writeKey("background_persist_interval");
        this.backgroundPersistInterval.serialize(generator, mapper);
        if (this.customSettings != null) {
            generator.writeKey("custom_settings");
            this.customSettings.serialize(generator, mapper);
        }
        if (this.dailyModelSnapshotRetentionAfterDays != null) {
            generator.writeKey("daily_model_snapshot_retention_after_days");
            generator.write(this.dailyModelSnapshotRetentionAfterDays.longValue());
        }
        generator.writeKey("data_description");
        this.dataDescription.serialize(generator, mapper);
        if (this.datafeedConfig != null) {
            generator.writeKey("datafeed_config");
            this.datafeedConfig.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.groups)) {
            generator.writeKey("groups");
            generator.writeStartArray();
            for (String item0 : this.groups) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.modelPlotConfig != null) {
            generator.writeKey("model_plot_config");
            this.modelPlotConfig.serialize(generator, mapper);
        }
        if (this.modelSnapshotRetentionDays != null) {
            generator.writeKey("model_snapshot_retention_days");
            generator.write(this.modelSnapshotRetentionDays.longValue());
        }
        if (this.renormalizationWindowDays != null) {
            generator.writeKey("renormalization_window_days");
            generator.write(this.renormalizationWindowDays.longValue());
        }
        if (this.resultsIndexName != null) {
            generator.writeKey("results_index_name");
            generator.write(this.resultsIndexName);
        }
        if (this.resultsRetentionDays != null) {
            generator.writeKey("results_retention_days");
            generator.write(this.resultsRetentionDays.longValue());
        }
    }

    protected static void setupPutJobRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowLazyOpen, JsonpDeserializer.booleanDeserializer(), "allow_lazy_open");
        op.add(Builder::analysisConfig, AnalysisConfig._DESERIALIZER, "analysis_config");
        op.add(Builder::analysisLimits, AnalysisLimits._DESERIALIZER, "analysis_limits");
        op.add(Builder::backgroundPersistInterval, Time._DESERIALIZER, "background_persist_interval");
        op.add(Builder::customSettings, JsonData._DESERIALIZER, "custom_settings");
        op.add(Builder::dailyModelSnapshotRetentionAfterDays, JsonpDeserializer.longDeserializer(), "daily_model_snapshot_retention_after_days");
        op.add(Builder::dataDescription, DataDescription._DESERIALIZER, "data_description");
        op.add(Builder::datafeedConfig, DatafeedConfig._DESERIALIZER, "datafeed_config");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "groups");
        op.add(Builder::modelPlotConfig, ModelPlotConfig._DESERIALIZER, "model_plot_config");
        op.add(Builder::modelSnapshotRetentionDays, JsonpDeserializer.longDeserializer(), "model_snapshot_retention_days");
        op.add(Builder::renormalizationWindowDays, JsonpDeserializer.longDeserializer(), "renormalization_window_days");
        op.add(Builder::resultsIndexName, JsonpDeserializer.stringDeserializer(), "results_index_name");
        op.add(Builder::resultsRetentionDays, JsonpDeserializer.longDeserializer(), "results_retention_days");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PutJobRequest> {
        @Nullable
        private Boolean allowLazyOpen;
        private AnalysisConfig analysisConfig;
        @Nullable
        private AnalysisLimits analysisLimits;
        private Time backgroundPersistInterval;
        @Nullable
        private JsonData customSettings;
        @Nullable
        private Long dailyModelSnapshotRetentionAfterDays;
        private DataDescription dataDescription;
        @Nullable
        private DatafeedConfig datafeedConfig;
        @Nullable
        private String description;
        @Nullable
        private List<String> groups;
        private String jobId;
        @Nullable
        private ModelPlotConfig modelPlotConfig;
        @Nullable
        private Long modelSnapshotRetentionDays;
        @Nullable
        private Long renormalizationWindowDays;
        @Nullable
        private String resultsIndexName;
        @Nullable
        private Long resultsRetentionDays;

        public final Builder allowLazyOpen(@Nullable Boolean value) {
            this.allowLazyOpen = value;
            return this;
        }

        public final Builder analysisConfig(AnalysisConfig value) {
            this.analysisConfig = value;
            return this;
        }

        public final Builder analysisConfig(Function<AnalysisConfig.Builder, ObjectBuilder<AnalysisConfig>> fn) {
            return this.analysisConfig(fn.apply(new AnalysisConfig.Builder()).build());
        }

        public final Builder analysisLimits(@Nullable AnalysisLimits value) {
            this.analysisLimits = value;
            return this;
        }

        public final Builder analysisLimits(Function<AnalysisLimits.Builder, ObjectBuilder<AnalysisLimits>> fn) {
            return this.analysisLimits(fn.apply(new AnalysisLimits.Builder()).build());
        }

        public final Builder backgroundPersistInterval(Time value) {
            this.backgroundPersistInterval = value;
            return this;
        }

        public final Builder backgroundPersistInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.backgroundPersistInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder customSettings(@Nullable JsonData value) {
            this.customSettings = value;
            return this;
        }

        public final Builder dailyModelSnapshotRetentionAfterDays(@Nullable Long value) {
            this.dailyModelSnapshotRetentionAfterDays = value;
            return this;
        }

        public final Builder dataDescription(DataDescription value) {
            this.dataDescription = value;
            return this;
        }

        public final Builder dataDescription(Function<DataDescription.Builder, ObjectBuilder<DataDescription>> fn) {
            return this.dataDescription(fn.apply(new DataDescription.Builder()).build());
        }

        public final Builder datafeedConfig(@Nullable DatafeedConfig value) {
            this.datafeedConfig = value;
            return this;
        }

        public final Builder datafeedConfig(Function<DatafeedConfig.Builder, ObjectBuilder<DatafeedConfig>> fn) {
            return this.datafeedConfig(fn.apply(new DatafeedConfig.Builder()).build());
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder groups(List<String> list) {
            this.groups = Builder._listAddAll(this.groups, list);
            return this;
        }

        public final Builder groups(String value, String ... values) {
            this.groups = Builder._listAdd(this.groups, value, values);
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder modelPlotConfig(@Nullable ModelPlotConfig value) {
            this.modelPlotConfig = value;
            return this;
        }

        public final Builder modelPlotConfig(Function<ModelPlotConfig.Builder, ObjectBuilder<ModelPlotConfig>> fn) {
            return this.modelPlotConfig(fn.apply(new ModelPlotConfig.Builder()).build());
        }

        public final Builder modelSnapshotRetentionDays(@Nullable Long value) {
            this.modelSnapshotRetentionDays = value;
            return this;
        }

        public final Builder renormalizationWindowDays(@Nullable Long value) {
            this.renormalizationWindowDays = value;
            return this;
        }

        public final Builder resultsIndexName(@Nullable String value) {
            this.resultsIndexName = value;
            return this;
        }

        public final Builder resultsRetentionDays(@Nullable Long value) {
            this.resultsRetentionDays = value;
            return this;
        }

        @Override
        public PutJobRequest build() {
            this._checkSingleUse();
            return new PutJobRequest(this);
        }
    }
}

