/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.TranslogRetention;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Translog
implements JsonpSerializable {
    @Nullable
    private final String durability;
    @Nullable
    private final String flushThresholdSize;
    @Nullable
    private final TranslogRetention retention;
    public static final JsonpDeserializer<Translog> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Translog::setupTranslogDeserializer);

    private Translog(Builder builder) {
        this.durability = builder.durability;
        this.flushThresholdSize = builder.flushThresholdSize;
        this.retention = builder.retention;
    }

    public static Translog of(Function<Builder, ObjectBuilder<Translog>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String durability() {
        return this.durability;
    }

    @Nullable
    public final String flushThresholdSize() {
        return this.flushThresholdSize;
    }

    @Nullable
    public final TranslogRetention retention() {
        return this.retention;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.durability != null) {
            generator.writeKey("durability");
            generator.write(this.durability);
        }
        if (this.flushThresholdSize != null) {
            generator.writeKey("flush_threshold_size");
            generator.write(this.flushThresholdSize);
        }
        if (this.retention != null) {
            generator.writeKey("retention");
            this.retention.serialize(generator, mapper);
        }
    }

    protected static void setupTranslogDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::durability, JsonpDeserializer.stringDeserializer(), "durability");
        op.add(Builder::flushThresholdSize, JsonpDeserializer.stringDeserializer(), "flush_threshold_size");
        op.add(Builder::retention, TranslogRetention._DESERIALIZER, "retention");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Translog> {
        @Nullable
        private String durability;
        @Nullable
        private String flushThresholdSize;
        @Nullable
        private TranslogRetention retention;

        public final Builder durability(@Nullable String value) {
            this.durability = value;
            return this;
        }

        public final Builder flushThresholdSize(@Nullable String value) {
            this.flushThresholdSize = value;
            return this;
        }

        public final Builder retention(@Nullable TranslogRetention value) {
            this.retention = value;
            return this;
        }

        public final Builder retention(Function<TranslogRetention.Builder, ObjectBuilder<TranslogRetention>> fn) {
            return this.retention(fn.apply(new TranslogRetention.Builder()).build());
        }

        @Override
        public Translog build() {
            this._checkSingleUse();
            return new Translog(this);
        }
    }
}

