/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CacheStats
implements JsonpSerializable {
    private final String nodeId;
    private final int count;
    private final int hits;
    private final int misses;
    private final int evictions;
    public static final JsonpDeserializer<CacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CacheStats::setupCacheStatsDeserializer);

    private CacheStats(Builder builder) {
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, this, "hits");
        this.misses = ApiTypeHelper.requireNonNull(builder.misses, this, "misses");
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, this, "evictions");
    }

    public static CacheStats of(Function<Builder, ObjectBuilder<CacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final int count() {
        return this.count;
    }

    public final int hits() {
        return this.hits;
    }

    public final int misses() {
        return this.misses;
    }

    public final int evictions() {
        return this.evictions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("hits");
        generator.write(this.hits);
        generator.writeKey("misses");
        generator.write(this.misses);
        generator.writeKey("evictions");
        generator.write(this.evictions);
    }

    protected static void setupCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::hits, JsonpDeserializer.integerDeserializer(), "hits");
        op.add(Builder::misses, JsonpDeserializer.integerDeserializer(), "misses");
        op.add(Builder::evictions, JsonpDeserializer.integerDeserializer(), "evictions");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CacheStats> {
        private String nodeId;
        private Integer count;
        private Integer hits;
        private Integer misses;
        private Integer evictions;

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder hits(int value) {
            this.hits = value;
            return this;
        }

        public final Builder misses(int value) {
            this.misses = value;
            return this;
        }

        public final Builder evictions(int value) {
            this.evictions = value;
            return this;
        }

        @Override
        public CacheStats build() {
            this._checkSingleUse();
            return new CacheStats(this);
        }
    }
}

