/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.ClearScrollResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClearScrollRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> scrollId;
    public static final JsonpDeserializer<ClearScrollRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClearScrollRequest::setupClearScrollRequestDeserializer);
    public static final Endpoint<ClearScrollRequest, ClearScrollResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ClearScrollRequest, ClearScrollResponse>("es/clear_scroll", request -> "DELETE", request -> "/_search/scroll", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ClearScrollResponse._DESERIALIZER);

    private ClearScrollRequest(Builder builder) {
        this.scrollId = ApiTypeHelper.unmodifiable(builder.scrollId);
    }

    public static ClearScrollRequest of(Function<Builder, ObjectBuilder<ClearScrollRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> scrollId() {
        return this.scrollId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.scrollId)) {
            generator.writeKey("scroll_id");
            generator.writeStartArray();
            for (String item0 : this.scrollId) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupClearScrollRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::scrollId, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "scroll_id");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClearScrollRequest> {
        @Nullable
        private List<String> scrollId;

        public final Builder scrollId(List<String> list) {
            this.scrollId = Builder._listAddAll(this.scrollId, list);
            return this;
        }

        public final Builder scrollId(String value, String ... values) {
            this.scrollId = Builder._listAdd(this.scrollId, value, values);
            return this;
        }

        @Override
        public ClearScrollRequest build() {
            this._checkSingleUse();
            return new ClearScrollRequest(this);
        }
    }
}

