/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Result;
import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class WriteResponseBase
implements JsonpSerializable {
    private final String id;
    private final String index;
    private final long primaryTerm;
    private final Result result;
    private final long seqNo;
    private final ShardStatistics shards;
    private final long version;
    @Nullable
    private final Boolean forcedRefresh;

    protected WriteResponseBase(AbstractBuilder<?> builder) {
        this.id = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).id, this, "id");
        this.index = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).index, this, "index");
        this.primaryTerm = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).primaryTerm, this, "primaryTerm");
        this.result = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).result, this, "result");
        this.seqNo = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).seqNo, this, "seqNo");
        this.shards = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).shards, this, "shards");
        this.version = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).version, this, "version");
        this.forcedRefresh = ((AbstractBuilder)builder).forcedRefresh;
    }

    public final String id() {
        return this.id;
    }

    public final String index() {
        return this.index;
    }

    public final long primaryTerm() {
        return this.primaryTerm;
    }

    public final Result result() {
        return this.result;
    }

    public final long seqNo() {
        return this.seqNo;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final long version() {
        return this.version;
    }

    @Nullable
    public final Boolean forcedRefresh() {
        return this.forcedRefresh;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_primary_term");
        generator.write(this.primaryTerm);
        generator.writeKey("result");
        this.result.serialize(generator, mapper);
        generator.writeKey("_seq_no");
        generator.write(this.seqNo);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("_version");
        generator.write(this.version);
        if (this.forcedRefresh != null) {
            generator.writeKey("forced_refresh");
            generator.write(this.forcedRefresh.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupWriteResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(AbstractBuilder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(AbstractBuilder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term");
        op.add(AbstractBuilder::result, Result._DESERIALIZER, "result");
        op.add(AbstractBuilder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(AbstractBuilder::version, JsonpDeserializer.longDeserializer(), "_version");
        op.add(AbstractBuilder::forcedRefresh, JsonpDeserializer.booleanDeserializer(), "forced_refresh");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        private String id;
        private String index;
        private Long primaryTerm;
        private Result result;
        private Long seqNo;
        private ShardStatistics shards;
        private Long version;
        @Nullable
        private Boolean forcedRefresh;

        protected AbstractBuilder() {
        }

        public final BuilderT id(String value) {
            this.id = value;
            return this.self();
        }

        public final BuilderT index(String value) {
            this.index = value;
            return this.self();
        }

        public final BuilderT primaryTerm(long value) {
            this.primaryTerm = value;
            return this.self();
        }

        public final BuilderT result(Result value) {
            this.result = value;
            return this.self();
        }

        public final BuilderT seqNo(long value) {
            this.seqNo = value;
            return this.self();
        }

        public final BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return this.self();
        }

        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final BuilderT version(long value) {
            this.version = value;
            return this.self();
        }

        public final BuilderT forcedRefresh(@Nullable Boolean value) {
            this.forcedRefresh = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

