/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.info;

import co.elastic.clients.elasticsearch.xpack.info.NativeCodeInformation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Feature
implements JsonpSerializable {
    private final boolean available;
    @Nullable
    private final String description;
    private final boolean enabled;
    @Nullable
    private final NativeCodeInformation nativeCodeInfo;
    public static final JsonpDeserializer<Feature> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Feature::setupFeatureDeserializer);

    private Feature(Builder builder) {
        this.available = ApiTypeHelper.requireNonNull(builder.available, this, "available");
        this.description = builder.description;
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, this, "enabled");
        this.nativeCodeInfo = builder.nativeCodeInfo;
    }

    public static Feature of(Function<Builder, ObjectBuilder<Feature>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean available() {
        return this.available;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final NativeCodeInformation nativeCodeInfo() {
        return this.nativeCodeInfo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available");
        generator.write(this.available);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("enabled");
        generator.write(this.enabled);
        if (this.nativeCodeInfo != null) {
            generator.writeKey("native_code_info");
            this.nativeCodeInfo.serialize(generator, mapper);
        }
    }

    protected static void setupFeatureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::available, JsonpDeserializer.booleanDeserializer(), "available");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::nativeCodeInfo, NativeCodeInformation._DESERIALIZER, "native_code_info");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Feature> {
        private Boolean available;
        @Nullable
        private String description;
        private Boolean enabled;
        @Nullable
        private NativeCodeInformation nativeCodeInfo;

        public final Builder available(boolean value) {
            this.available = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder nativeCodeInfo(@Nullable NativeCodeInformation value) {
            this.nativeCodeInfo = value;
            return this;
        }

        public final Builder nativeCodeInfo(Function<NativeCodeInformation.Builder, ObjectBuilder<NativeCodeInformation>> fn) {
            return this.nativeCodeInfo(fn.apply(new NativeCodeInformation.Builder()).build());
        }

        @Override
        public Feature build() {
            this._checkSingleUse();
            return new Feature(this);
        }
    }
}

