/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.watcher.ActionExecutionMode;
import co.elastic.clients.elasticsearch.watcher.ExecuteWatchResponse;
import co.elastic.clients.elasticsearch.watcher.ScheduleTriggerEvent;
import co.elastic.clients.elasticsearch.watcher.SimulatedActions;
import co.elastic.clients.elasticsearch.watcher.Watch;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExecuteWatchRequest
extends RequestBase
implements JsonpSerializable {
    private final Map<String, ActionExecutionMode> actionModes;
    private final Map<String, JsonData> alternativeInput;
    @Nullable
    private final Boolean debug;
    @Nullable
    private final String id;
    @Nullable
    private final Boolean ignoreCondition;
    @Nullable
    private final Boolean recordExecution;
    @Nullable
    private final SimulatedActions simulatedActions;
    @Nullable
    private final ScheduleTriggerEvent triggerData;
    @Nullable
    private final Watch watch;
    public static final JsonpDeserializer<ExecuteWatchRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecuteWatchRequest::setupExecuteWatchRequestDeserializer);
    public static final Endpoint<ExecuteWatchRequest, ExecuteWatchResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ExecuteWatchRequest, ExecuteWatchResponse>("es/watcher.execute_watch", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            buf.append("/_execute");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/_execute");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.debug != null) {
            params.put("debug", String.valueOf(request.debug));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ExecuteWatchResponse._DESERIALIZER);

    private ExecuteWatchRequest(Builder builder) {
        this.actionModes = ApiTypeHelper.unmodifiable(builder.actionModes);
        this.alternativeInput = ApiTypeHelper.unmodifiable(builder.alternativeInput);
        this.debug = builder.debug;
        this.id = builder.id;
        this.ignoreCondition = builder.ignoreCondition;
        this.recordExecution = builder.recordExecution;
        this.simulatedActions = builder.simulatedActions;
        this.triggerData = builder.triggerData;
        this.watch = builder.watch;
    }

    public static ExecuteWatchRequest of(Function<Builder, ObjectBuilder<ExecuteWatchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, ActionExecutionMode> actionModes() {
        return this.actionModes;
    }

    public final Map<String, JsonData> alternativeInput() {
        return this.alternativeInput;
    }

    @Nullable
    public final Boolean debug() {
        return this.debug;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Boolean ignoreCondition() {
        return this.ignoreCondition;
    }

    @Nullable
    public final Boolean recordExecution() {
        return this.recordExecution;
    }

    @Nullable
    public final SimulatedActions simulatedActions() {
        return this.simulatedActions;
    }

    @Nullable
    public final ScheduleTriggerEvent triggerData() {
        return this.triggerData;
    }

    @Nullable
    public final Watch watch() {
        return this.watch;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actionModes)) {
            generator.writeKey("action_modes");
            generator.writeStartObject();
            for (Map.Entry<String, ActionExecutionMode> entry : this.actionModes.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.alternativeInput)) {
            generator.writeKey("alternative_input");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.alternativeInput.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreCondition != null) {
            generator.writeKey("ignore_condition");
            generator.write(this.ignoreCondition.booleanValue());
        }
        if (this.recordExecution != null) {
            generator.writeKey("record_execution");
            generator.write(this.recordExecution.booleanValue());
        }
        if (this.simulatedActions != null) {
            generator.writeKey("simulated_actions");
            this.simulatedActions.serialize(generator, mapper);
        }
        if (this.triggerData != null) {
            generator.writeKey("trigger_data");
            this.triggerData.serialize(generator, mapper);
        }
        if (this.watch != null) {
            generator.writeKey("watch");
            this.watch.serialize(generator, mapper);
        }
    }

    protected static void setupExecuteWatchRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actionModes, JsonpDeserializer.stringMapDeserializer(ActionExecutionMode._DESERIALIZER), "action_modes");
        op.add(Builder::alternativeInput, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "alternative_input");
        op.add(Builder::ignoreCondition, JsonpDeserializer.booleanDeserializer(), "ignore_condition");
        op.add(Builder::recordExecution, JsonpDeserializer.booleanDeserializer(), "record_execution");
        op.add(Builder::simulatedActions, SimulatedActions._DESERIALIZER, "simulated_actions");
        op.add(Builder::triggerData, ScheduleTriggerEvent._DESERIALIZER, "trigger_data");
        op.add(Builder::watch, Watch._DESERIALIZER, "watch");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ExecuteWatchRequest> {
        @Nullable
        private Map<String, ActionExecutionMode> actionModes;
        @Nullable
        private Map<String, JsonData> alternativeInput;
        @Nullable
        private Boolean debug;
        @Nullable
        private String id;
        @Nullable
        private Boolean ignoreCondition;
        @Nullable
        private Boolean recordExecution;
        @Nullable
        private SimulatedActions simulatedActions;
        @Nullable
        private ScheduleTriggerEvent triggerData;
        @Nullable
        private Watch watch;

        public final Builder actionModes(Map<String, ActionExecutionMode> map) {
            this.actionModes = Builder._mapPutAll(this.actionModes, map);
            return this;
        }

        public final Builder actionModes(String key, ActionExecutionMode value) {
            this.actionModes = Builder._mapPut(this.actionModes, key, value);
            return this;
        }

        public final Builder alternativeInput(Map<String, JsonData> map) {
            this.alternativeInput = Builder._mapPutAll(this.alternativeInput, map);
            return this;
        }

        public final Builder alternativeInput(String key, JsonData value) {
            this.alternativeInput = Builder._mapPut(this.alternativeInput, key, value);
            return this;
        }

        public final Builder debug(@Nullable Boolean value) {
            this.debug = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder ignoreCondition(@Nullable Boolean value) {
            this.ignoreCondition = value;
            return this;
        }

        public final Builder recordExecution(@Nullable Boolean value) {
            this.recordExecution = value;
            return this;
        }

        public final Builder simulatedActions(@Nullable SimulatedActions value) {
            this.simulatedActions = value;
            return this;
        }

        public final Builder simulatedActions(Function<SimulatedActions.Builder, ObjectBuilder<SimulatedActions>> fn) {
            return this.simulatedActions(fn.apply(new SimulatedActions.Builder()).build());
        }

        public final Builder triggerData(@Nullable ScheduleTriggerEvent value) {
            this.triggerData = value;
            return this;
        }

        public final Builder triggerData(Function<ScheduleTriggerEvent.Builder, ObjectBuilder<ScheduleTriggerEvent>> fn) {
            return this.triggerData(fn.apply(new ScheduleTriggerEvent.Builder()).build());
        }

        public final Builder watch(@Nullable Watch value) {
            this.watch = value;
            return this;
        }

        public final Builder watch(Function<Watch.Builder, ObjectBuilder<Watch>> fn) {
            return this.watch(fn.apply(new Watch.Builder()).build());
        }

        @Override
        public ExecuteWatchRequest build() {
            this._checkSingleUse();
            return new ExecuteWatchRequest(this);
        }
    }
}

