/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.CreateRepositoryResponse;
import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.elasticsearch.snapshot.RepositorySettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CreateRepositoryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time masterTimeout;
    private final String name;
    @Nullable
    private final Repository repository;
    private final RepositorySettings settings;
    @Nullable
    private final Time timeout;
    private final String type;
    @Nullable
    private final Boolean verify;
    public static final JsonpDeserializer<CreateRepositoryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CreateRepositoryRequest::setupCreateRepositoryRequestDeserializer);
    public static final Endpoint<CreateRepositoryRequest, CreateRepositoryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateRepositoryRequest, CreateRepositoryResponse>("es/snapshot.create_repository", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.verify != null) {
            params.put("verify", String.valueOf(request.verify));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateRepositoryResponse._DESERIALIZER);

    private CreateRepositoryRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.repository = builder.repository;
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
        this.timeout = builder.timeout;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.verify = builder.verify;
    }

    public static CreateRepositoryRequest of(Function<Builder, ObjectBuilder<CreateRepositoryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Repository repository() {
        return this.repository;
    }

    public final RepositorySettings settings() {
        return this.settings;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final String type() {
        return this.type;
    }

    @Nullable
    public final Boolean verify() {
        return this.verify;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.repository != null) {
            generator.writeKey("repository");
            this.repository.serialize(generator, mapper);
        }
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupCreateRepositoryRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::repository, Repository._DESERIALIZER, "repository");
        op.add(Builder::settings, RepositorySettings._DESERIALIZER, "settings");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CreateRepositoryRequest> {
        @Nullable
        private Time masterTimeout;
        private String name;
        @Nullable
        private Repository repository;
        private RepositorySettings settings;
        @Nullable
        private Time timeout;
        private String type;
        @Nullable
        private Boolean verify;

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder repository(@Nullable Repository value) {
            this.repository = value;
            return this;
        }

        public final Builder repository(Function<Repository.Builder, ObjectBuilder<Repository>> fn) {
            return this.repository(fn.apply(new Repository.Builder()).build());
        }

        public final Builder settings(RepositorySettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<RepositorySettings.Builder, ObjectBuilder<RepositorySettings>> fn) {
            return this.settings(fn.apply(new RepositorySettings.Builder()).build());
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder verify(@Nullable Boolean value) {
            this.verify = value;
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            this._checkSingleUse();
            return new CreateRepositoryRequest(this);
        }
    }
}

