/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.GeoLocation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TopLeftBottomRightGeoBounds
implements JsonpSerializable {
    private final GeoLocation topLeft;
    private final GeoLocation bottomRight;
    public static final JsonpDeserializer<TopLeftBottomRightGeoBounds> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopLeftBottomRightGeoBounds::setupTopLeftBottomRightGeoBoundsDeserializer);

    private TopLeftBottomRightGeoBounds(Builder builder) {
        this.topLeft = ApiTypeHelper.requireNonNull(builder.topLeft, this, "topLeft");
        this.bottomRight = ApiTypeHelper.requireNonNull(builder.bottomRight, this, "bottomRight");
    }

    public static TopLeftBottomRightGeoBounds of(Function<Builder, ObjectBuilder<TopLeftBottomRightGeoBounds>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final GeoLocation topLeft() {
        return this.topLeft;
    }

    public final GeoLocation bottomRight() {
        return this.bottomRight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("top_left");
        this.topLeft.serialize(generator, mapper);
        generator.writeKey("bottom_right");
        this.bottomRight.serialize(generator, mapper);
    }

    protected static void setupTopLeftBottomRightGeoBoundsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::topLeft, GeoLocation._DESERIALIZER, "top_left");
        op.add(Builder::bottomRight, GeoLocation._DESERIALIZER, "bottom_right");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TopLeftBottomRightGeoBounds> {
        private GeoLocation topLeft;
        private GeoLocation bottomRight;

        public final Builder topLeft(GeoLocation value) {
            this.topLeft = value;
            return this;
        }

        public final Builder topLeft(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.topLeft(fn.apply(new GeoLocation.Builder()).build());
        }

        public final Builder bottomRight(GeoLocation value) {
            this.bottomRight = value;
            return this;
        }

        public final Builder bottomRight(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.bottomRight(fn.apply(new GeoLocation.Builder()).build());
        }

        @Override
        public TopLeftBottomRightGeoBounds build() {
            this._checkSingleUse();
            return new TopLeftBottomRightGeoBounds(this);
        }
    }
}

