/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.xpack.XpackInfoRequest;
import co.elastic.clients.elasticsearch.xpack.XpackInfoResponse;
import co.elastic.clients.elasticsearch.xpack.XpackUsageRequest;
import co.elastic.clients.elasticsearch.xpack.XpackUsageResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchXpackAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchXpackAsyncClient> {
    public ElasticsearchXpackAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchXpackAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchXpackAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchXpackAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<XpackInfoResponse> info(XpackInfoRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)XpackInfoRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<XpackInfoResponse> info(Function<XpackInfoRequest.Builder, ObjectBuilder<XpackInfoRequest>> fn) throws IOException, ElasticsearchException {
        return this.info(fn.apply(new XpackInfoRequest.Builder()).build());
    }

    public CompletableFuture<XpackInfoResponse> info() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new XpackInfoRequest.Builder().build(), XpackInfoRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<XpackUsageResponse> usage(XpackUsageRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)XpackUsageRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<XpackUsageResponse> usage(Function<XpackUsageRequest.Builder, ObjectBuilder<XpackUsageRequest>> fn) throws IOException, ElasticsearchException {
        return this.usage(fn.apply(new XpackUsageRequest.Builder()).build());
    }

    public CompletableFuture<XpackUsageResponse> usage() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new XpackUsageRequest.Builder().build(), XpackUsageRequest._ENDPOINT, this.transportOptions);
    }
}

