/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluation;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationRegressionMetrics;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeEvaluationRegression
implements DataframeEvaluationVariant,
JsonpSerializable {
    private final String actualField;
    private final String predictedField;
    @Nullable
    private final DataframeEvaluationRegressionMetrics metrics;
    public static final JsonpDeserializer<DataframeEvaluationRegression> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeEvaluationRegression::setupDataframeEvaluationRegressionDeserializer);

    private DataframeEvaluationRegression(Builder builder) {
        this.actualField = ApiTypeHelper.requireNonNull(builder.actualField, this, "actualField");
        this.predictedField = ApiTypeHelper.requireNonNull(builder.predictedField, this, "predictedField");
        this.metrics = builder.metrics;
    }

    public static DataframeEvaluationRegression of(Function<Builder, ObjectBuilder<DataframeEvaluationRegression>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public DataframeEvaluation.Kind _dataframeEvaluationKind() {
        return DataframeEvaluation.Kind.Regression;
    }

    public final String actualField() {
        return this.actualField;
    }

    public final String predictedField() {
        return this.predictedField;
    }

    @Nullable
    public final DataframeEvaluationRegressionMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actual_field");
        generator.write(this.actualField);
        generator.writeKey("predicted_field");
        generator.write(this.predictedField);
        if (this.metrics != null) {
            generator.writeKey("metrics");
            this.metrics.serialize(generator, mapper);
        }
    }

    protected static void setupDataframeEvaluationRegressionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actualField, JsonpDeserializer.stringDeserializer(), "actual_field");
        op.add(Builder::predictedField, JsonpDeserializer.stringDeserializer(), "predicted_field");
        op.add(Builder::metrics, DataframeEvaluationRegressionMetrics._DESERIALIZER, "metrics");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataframeEvaluationRegression> {
        private String actualField;
        private String predictedField;
        @Nullable
        private DataframeEvaluationRegressionMetrics metrics;

        public final Builder actualField(String value) {
            this.actualField = value;
            return this;
        }

        public final Builder predictedField(String value) {
            this.predictedField = value;
            return this;
        }

        public final Builder metrics(@Nullable DataframeEvaluationRegressionMetrics value) {
            this.metrics = value;
            return this;
        }

        public final Builder metrics(Function<DataframeEvaluationRegressionMetrics.Builder, ObjectBuilder<DataframeEvaluationRegressionMetrics>> fn) {
            return this.metrics(fn.apply(new DataframeEvaluationRegressionMetrics.Builder()).build());
        }

        @Override
        public DataframeEvaluationRegression build() {
            this._checkSingleUse();
            return new DataframeEvaluationRegression(this);
        }
    }
}

