/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ilm.MoveToStepResponse;
import co.elastic.clients.elasticsearch.ilm.move_to_step.StepKey;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MoveToStepRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final StepKey currentStep;
    private final String index;
    @Nullable
    private final StepKey nextStep;
    public static final JsonpDeserializer<MoveToStepRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MoveToStepRequest::setupMoveToStepRequestDeserializer);
    public static final Endpoint<MoveToStepRequest, MoveToStepResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<MoveToStepRequest, MoveToStepResponse>("es/ilm.move_to_step", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ilm");
            buf.append("/move");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, MoveToStepResponse._DESERIALIZER);

    private MoveToStepRequest(Builder builder) {
        this.currentStep = builder.currentStep;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.nextStep = builder.nextStep;
    }

    public static MoveToStepRequest of(Function<Builder, ObjectBuilder<MoveToStepRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final StepKey currentStep() {
        return this.currentStep;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final StepKey nextStep() {
        return this.nextStep;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentStep != null) {
            generator.writeKey("current_step");
            this.currentStep.serialize(generator, mapper);
        }
        if (this.nextStep != null) {
            generator.writeKey("next_step");
            this.nextStep.serialize(generator, mapper);
        }
    }

    protected static void setupMoveToStepRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentStep, StepKey._DESERIALIZER, "current_step");
        op.add(Builder::nextStep, StepKey._DESERIALIZER, "next_step");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MoveToStepRequest> {
        @Nullable
        private StepKey currentStep;
        private String index;
        @Nullable
        private StepKey nextStep;

        public final Builder currentStep(@Nullable StepKey value) {
            this.currentStep = value;
            return this;
        }

        public final Builder currentStep(Function<StepKey.Builder, ObjectBuilder<StepKey>> fn) {
            return this.currentStep(fn.apply(new StepKey.Builder()).build());
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder nextStep(@Nullable StepKey value) {
            this.nextStep = value;
            return this;
        }

        public final Builder nextStep(Function<StepKey.Builder, ObjectBuilder<StepKey>> fn) {
            return this.nextStep(fn.apply(new StepKey.Builder()).build());
        }

        @Override
        public MoveToStepRequest build() {
            this._checkSingleUse();
            return new MoveToStepRequest(this);
        }
    }
}

