/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.eql.EqlDeleteRequest;
import co.elastic.clients.elasticsearch.eql.EqlDeleteResponse;
import co.elastic.clients.elasticsearch.eql.EqlGetRequest;
import co.elastic.clients.elasticsearch.eql.EqlGetResponse;
import co.elastic.clients.elasticsearch.eql.EqlSearchRequest;
import co.elastic.clients.elasticsearch.eql.EqlSearchResponse;
import co.elastic.clients.elasticsearch.eql.GetEqlStatusRequest;
import co.elastic.clients.elasticsearch.eql.GetEqlStatusResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.transport.endpoints.EndpointWithResponseMapperAttr;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchEqlAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchEqlAsyncClient> {
    public ElasticsearchEqlAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchEqlAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchEqlAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchEqlAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<EqlDeleteResponse> delete(EqlDeleteRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)EqlDeleteRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<EqlDeleteResponse> delete(Function<EqlDeleteRequest.Builder, ObjectBuilder<EqlDeleteRequest>> fn) throws IOException, ElasticsearchException {
        return this.delete(fn.apply(new EqlDeleteRequest.Builder()).build());
    }

    public <TEvent> CompletableFuture<EqlGetResponse<TEvent>> get(EqlGetRequest request, Class<TEvent> tEventClass) throws IOException, ElasticsearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = EqlGetRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "co.elastic.clients:Deserializer:eql.get.TEvent", this.getDeserializer(tEventClass));
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TEvent> CompletableFuture<EqlGetResponse<TEvent>> get(Function<EqlGetRequest.Builder, ObjectBuilder<EqlGetRequest>> fn, Class<TEvent> tEventClass) throws IOException, ElasticsearchException {
        return this.get(fn.apply(new EqlGetRequest.Builder()).build(), tEventClass);
    }

    public CompletableFuture<GetEqlStatusResponse> getStatus(GetEqlStatusRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetEqlStatusRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetEqlStatusResponse> getStatus(Function<GetEqlStatusRequest.Builder, ObjectBuilder<GetEqlStatusRequest>> fn) throws IOException, ElasticsearchException {
        return this.getStatus(fn.apply(new GetEqlStatusRequest.Builder()).build());
    }

    public <TEvent> CompletableFuture<EqlSearchResponse<TEvent>> search(EqlSearchRequest request, Class<TEvent> tEventClass) throws IOException, ElasticsearchException {
        JsonEndpoint<Object, Object, ErrorResponse> endpoint = EqlSearchRequest._ENDPOINT;
        endpoint = new EndpointWithResponseMapperAttr(endpoint, "co.elastic.clients:Deserializer:eql.search.TEvent", this.getDeserializer(tEventClass));
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final <TEvent> CompletableFuture<EqlSearchResponse<TEvent>> search(Function<EqlSearchRequest.Builder, ObjectBuilder<EqlSearchRequest>> fn, Class<TEvent> tEventClass) throws IOException, ElasticsearchException {
        return this.search(fn.apply(new EqlSearchRequest.Builder()).build(), tEventClass);
    }
}

