/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpMapperBase;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import jakarta.json.JsonException;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;

public class SimpleJsonpMapper
extends JsonpMapperBase {
    public static SimpleJsonpMapper INSTANCE = new SimpleJsonpMapper(true);
    public static SimpleJsonpMapper INSTANCE_REJECT_UNKNOWN_FIELDS = new SimpleJsonpMapper(false);
    private static final Map<Class<?>, JsonpSerializer<?>> serializers = new HashMap();
    private static final Map<Class<?>, JsonpDeserializer<?>> deserializers = new HashMap();
    private final boolean ignoreUnknownFields;

    public SimpleJsonpMapper(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public SimpleJsonpMapper() {
        this(true);
    }

    @Override
    public <T> JsonpMapper withAttribute(String name, T value) {
        return new SimpleJsonpMapper(this.ignoreUnknownFields).addAttribute(name, value);
    }

    @Override
    public boolean ignoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    @Override
    public JsonProvider jsonProvider() {
        return JsonpUtils.provider();
    }

    @Override
    public <T> void serialize(T value, JsonGenerator generator) {
        JsonpSerializer<Object> serializer = SimpleJsonpMapper.findSerializer(value);
        if (serializer == null) {
            JsonpSerializer<?> serializer_ = serializers.get(value.getClass());
            serializer = serializer_;
        }
        if (serializer == null) {
            serializer = this.getDefaultSerializer(value);
        }
        if (serializer == null) {
            throw new JsonException("Cannot find a serializer for type " + value.getClass().getName() + ". Consider using a full-featured JsonpMapper");
        }
        serializer.serialize(value, generator, this);
    }

    @Override
    protected <T> JsonpDeserializer<T> getDefaultDeserializer(Class<T> clazz) {
        JsonpDeserializer<?> deserializer = deserializers.get(clazz);
        if (deserializer != null) {
            return deserializer;
        }
        throw new JsonException("Cannot find a deserializer for type " + clazz.getName() + ". Consider using a full-featured JsonpMapper");
    }

    protected <T> JsonpSerializer<T> getDefaultSerializer(T value) {
        return null;
    }

    static {
        serializers.put(String.class, (value, generator, mapper) -> generator.write(value));
        serializers.put(Boolean.class, (value, generator, mapper) -> generator.write(value.booleanValue()));
        serializers.put(Boolean.TYPE, (value, generator, mapper) -> generator.write(value.booleanValue()));
        serializers.put(Integer.class, (value, generator, mapper) -> generator.write(value.intValue()));
        serializers.put(Integer.TYPE, (value, generator, mapper) -> generator.write(value.intValue()));
        serializers.put(Long.class, (value, generator, mapper) -> generator.write(value.longValue()));
        serializers.put(Long.TYPE, (value, generator, mapper) -> generator.write(value.longValue()));
        serializers.put(Float.class, (value, generator, mapper) -> generator.write((double)value.floatValue()));
        serializers.put(Float.TYPE, (value, generator, mapper) -> generator.write((double)value.floatValue()));
        serializers.put(Double.class, (value, generator, mapper) -> generator.write(value.doubleValue()));
        serializers.put(Double.TYPE, (value, generator, mapper) -> generator.write(value.doubleValue()));
        deserializers.put(String.class, JsonpDeserializer.stringDeserializer());
        deserializers.put(Boolean.class, JsonpDeserializer.booleanDeserializer());
        deserializers.put(Boolean.TYPE, JsonpDeserializer.booleanDeserializer());
        deserializers.put(Integer.class, JsonpDeserializer.integerDeserializer());
        deserializers.put(Integer.TYPE, JsonpDeserializer.integerDeserializer());
        deserializers.put(Long.class, JsonpDeserializer.longDeserializer());
        deserializers.put(Long.TYPE, JsonpDeserializer.longDeserializer());
        deserializers.put(Float.class, JsonpDeserializer.floatDeserializer());
        deserializers.put(Float.TYPE, JsonpDeserializer.floatDeserializer());
        deserializers.put(Double.class, JsonpDeserializer.doubleDeserializer());
        deserializers.put(Double.TYPE, JsonpDeserializer.doubleDeserializer());
    }
}

