/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AdjacencyMatrixAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.AutoDateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AverageBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.BoxplotAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.BucketScriptAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.BucketSelectorAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.BucketSortAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CardinalityAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ChildrenAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CumulativeCardinalityAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CumulativeSumAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DateRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DerivativeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.DiversifiedSamplerAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ExtendedStatsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ExtendedStatsBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.FiltersAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoBoundsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoCentroidAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoDistanceAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoHashGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoLineAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GeoTileGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.GlobalAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.HistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.InferenceAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.IpRangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MatrixStatsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MaxAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MaxBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MedianAbsoluteDeviationAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MinAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MinBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MissingAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MovingAverageAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MovingFunctionAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MovingPercentilesAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.MultiTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.NestedAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.NormalizeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ParentAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.PercentileRanksAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.PercentilesAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.PercentilesBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.RangeAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.RareTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.RateAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ReverseNestedAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SamplerAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ScriptedMetricAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SerialDifferencingAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SignificantTermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SignificantTextAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StatsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StatsBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.StringStatsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SumAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.SumBucketAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TTestAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TermsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TopHitsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.TopMetricsAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.ValueCountAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.VariableWidthHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.WeightedAverageAggregation;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Aggregation
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final Map<String, Aggregation> aggregations;
    private final Map<String, JsonData> meta;
    public static final JsonpDeserializer<Aggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Aggregation::setupAggregationDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Aggregation(AggregationVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._aggregationKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this.aggregations = null;
        this.meta = null;
    }

    private Aggregation(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
    }

    public static Aggregation of(Function<Builder, ObjectBuilder<Aggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    public boolean isAdjacencyMatrix() {
        return this._kind == Kind.AdjacencyMatrix;
    }

    public AdjacencyMatrixAggregation adjacencyMatrix() {
        return (AdjacencyMatrixAggregation)TaggedUnionUtils.get(this, Kind.AdjacencyMatrix);
    }

    public boolean isAutoDateHistogram() {
        return this._kind == Kind.AutoDateHistogram;
    }

    public AutoDateHistogramAggregation autoDateHistogram() {
        return (AutoDateHistogramAggregation)TaggedUnionUtils.get(this, Kind.AutoDateHistogram);
    }

    public boolean isAvg() {
        return this._kind == Kind.Avg;
    }

    public AverageAggregation avg() {
        return (AverageAggregation)TaggedUnionUtils.get(this, Kind.Avg);
    }

    public boolean isAvgBucket() {
        return this._kind == Kind.AvgBucket;
    }

    public AverageBucketAggregation avgBucket() {
        return (AverageBucketAggregation)TaggedUnionUtils.get(this, Kind.AvgBucket);
    }

    public boolean isBoxplot() {
        return this._kind == Kind.Boxplot;
    }

    public BoxplotAggregation boxplot() {
        return (BoxplotAggregation)TaggedUnionUtils.get(this, Kind.Boxplot);
    }

    public boolean isBucketScript() {
        return this._kind == Kind.BucketScript;
    }

    public BucketScriptAggregation bucketScript() {
        return (BucketScriptAggregation)TaggedUnionUtils.get(this, Kind.BucketScript);
    }

    public boolean isBucketSelector() {
        return this._kind == Kind.BucketSelector;
    }

    public BucketSelectorAggregation bucketSelector() {
        return (BucketSelectorAggregation)TaggedUnionUtils.get(this, Kind.BucketSelector);
    }

    public boolean isBucketSort() {
        return this._kind == Kind.BucketSort;
    }

    public BucketSortAggregation bucketSort() {
        return (BucketSortAggregation)TaggedUnionUtils.get(this, Kind.BucketSort);
    }

    public boolean isCardinality() {
        return this._kind == Kind.Cardinality;
    }

    public CardinalityAggregation cardinality() {
        return (CardinalityAggregation)TaggedUnionUtils.get(this, Kind.Cardinality);
    }

    public boolean isChildren() {
        return this._kind == Kind.Children;
    }

    public ChildrenAggregation children() {
        return (ChildrenAggregation)TaggedUnionUtils.get(this, Kind.Children);
    }

    public boolean isComposite() {
        return this._kind == Kind.Composite;
    }

    public CompositeAggregation composite() {
        return (CompositeAggregation)TaggedUnionUtils.get(this, Kind.Composite);
    }

    public boolean isCumulativeCardinality() {
        return this._kind == Kind.CumulativeCardinality;
    }

    public CumulativeCardinalityAggregation cumulativeCardinality() {
        return (CumulativeCardinalityAggregation)TaggedUnionUtils.get(this, Kind.CumulativeCardinality);
    }

    public boolean isCumulativeSum() {
        return this._kind == Kind.CumulativeSum;
    }

    public CumulativeSumAggregation cumulativeSum() {
        return (CumulativeSumAggregation)TaggedUnionUtils.get(this, Kind.CumulativeSum);
    }

    public boolean isDateHistogram() {
        return this._kind == Kind.DateHistogram;
    }

    public DateHistogramAggregation dateHistogram() {
        return (DateHistogramAggregation)TaggedUnionUtils.get(this, Kind.DateHistogram);
    }

    public boolean isDateRange() {
        return this._kind == Kind.DateRange;
    }

    public DateRangeAggregation dateRange() {
        return (DateRangeAggregation)TaggedUnionUtils.get(this, Kind.DateRange);
    }

    public boolean isDerivative() {
        return this._kind == Kind.Derivative;
    }

    public DerivativeAggregation derivative() {
        return (DerivativeAggregation)TaggedUnionUtils.get(this, Kind.Derivative);
    }

    public boolean isDiversifiedSampler() {
        return this._kind == Kind.DiversifiedSampler;
    }

    public DiversifiedSamplerAggregation diversifiedSampler() {
        return (DiversifiedSamplerAggregation)TaggedUnionUtils.get(this, Kind.DiversifiedSampler);
    }

    public boolean isExtendedStats() {
        return this._kind == Kind.ExtendedStats;
    }

    public ExtendedStatsAggregation extendedStats() {
        return (ExtendedStatsAggregation)TaggedUnionUtils.get(this, Kind.ExtendedStats);
    }

    public boolean isExtendedStatsBucket() {
        return this._kind == Kind.ExtendedStatsBucket;
    }

    public ExtendedStatsBucketAggregation extendedStatsBucket() {
        return (ExtendedStatsBucketAggregation)TaggedUnionUtils.get(this, Kind.ExtendedStatsBucket);
    }

    public boolean isFilter() {
        return this._kind == Kind.Filter;
    }

    public Query filter() {
        return (Query)TaggedUnionUtils.get(this, Kind.Filter);
    }

    public boolean isFilters() {
        return this._kind == Kind.Filters;
    }

    public FiltersAggregation filters() {
        return (FiltersAggregation)TaggedUnionUtils.get(this, Kind.Filters);
    }

    public boolean isGeoBounds() {
        return this._kind == Kind.GeoBounds;
    }

    public GeoBoundsAggregation geoBounds() {
        return (GeoBoundsAggregation)TaggedUnionUtils.get(this, Kind.GeoBounds);
    }

    public boolean isGeoCentroid() {
        return this._kind == Kind.GeoCentroid;
    }

    public GeoCentroidAggregation geoCentroid() {
        return (GeoCentroidAggregation)TaggedUnionUtils.get(this, Kind.GeoCentroid);
    }

    public boolean isGeoDistance() {
        return this._kind == Kind.GeoDistance;
    }

    public GeoDistanceAggregation geoDistance() {
        return (GeoDistanceAggregation)TaggedUnionUtils.get(this, Kind.GeoDistance);
    }

    public boolean isGeohashGrid() {
        return this._kind == Kind.GeohashGrid;
    }

    public GeoHashGridAggregation geohashGrid() {
        return (GeoHashGridAggregation)TaggedUnionUtils.get(this, Kind.GeohashGrid);
    }

    public boolean isGeoLine() {
        return this._kind == Kind.GeoLine;
    }

    public GeoLineAggregation geoLine() {
        return (GeoLineAggregation)TaggedUnionUtils.get(this, Kind.GeoLine);
    }

    public boolean isGeotileGrid() {
        return this._kind == Kind.GeotileGrid;
    }

    public GeoTileGridAggregation geotileGrid() {
        return (GeoTileGridAggregation)TaggedUnionUtils.get(this, Kind.GeotileGrid);
    }

    public boolean isGlobal() {
        return this._kind == Kind.Global;
    }

    public GlobalAggregation global() {
        return (GlobalAggregation)TaggedUnionUtils.get(this, Kind.Global);
    }

    public boolean isHistogram() {
        return this._kind == Kind.Histogram;
    }

    public HistogramAggregation histogram() {
        return (HistogramAggregation)TaggedUnionUtils.get(this, Kind.Histogram);
    }

    public boolean isIpRange() {
        return this._kind == Kind.IpRange;
    }

    public IpRangeAggregation ipRange() {
        return (IpRangeAggregation)TaggedUnionUtils.get(this, Kind.IpRange);
    }

    public boolean isInference() {
        return this._kind == Kind.Inference;
    }

    public InferenceAggregation inference() {
        return (InferenceAggregation)TaggedUnionUtils.get(this, Kind.Inference);
    }

    public boolean isMatrixStats() {
        return this._kind == Kind.MatrixStats;
    }

    public MatrixStatsAggregation matrixStats() {
        return (MatrixStatsAggregation)TaggedUnionUtils.get(this, Kind.MatrixStats);
    }

    public boolean isMax() {
        return this._kind == Kind.Max;
    }

    public MaxAggregation max() {
        return (MaxAggregation)TaggedUnionUtils.get(this, Kind.Max);
    }

    public boolean isMaxBucket() {
        return this._kind == Kind.MaxBucket;
    }

    public MaxBucketAggregation maxBucket() {
        return (MaxBucketAggregation)TaggedUnionUtils.get(this, Kind.MaxBucket);
    }

    public boolean isMedianAbsoluteDeviation() {
        return this._kind == Kind.MedianAbsoluteDeviation;
    }

    public MedianAbsoluteDeviationAggregation medianAbsoluteDeviation() {
        return (MedianAbsoluteDeviationAggregation)TaggedUnionUtils.get(this, Kind.MedianAbsoluteDeviation);
    }

    public boolean isMin() {
        return this._kind == Kind.Min;
    }

    public MinAggregation min() {
        return (MinAggregation)TaggedUnionUtils.get(this, Kind.Min);
    }

    public boolean isMinBucket() {
        return this._kind == Kind.MinBucket;
    }

    public MinBucketAggregation minBucket() {
        return (MinBucketAggregation)TaggedUnionUtils.get(this, Kind.MinBucket);
    }

    public boolean isMissing() {
        return this._kind == Kind.Missing;
    }

    public MissingAggregation missing() {
        return (MissingAggregation)TaggedUnionUtils.get(this, Kind.Missing);
    }

    public boolean isMovingAvg() {
        return this._kind == Kind.MovingAvg;
    }

    public MovingAverageAggregation movingAvg() {
        return (MovingAverageAggregation)TaggedUnionUtils.get(this, Kind.MovingAvg);
    }

    public boolean isMovingPercentiles() {
        return this._kind == Kind.MovingPercentiles;
    }

    public MovingPercentilesAggregation movingPercentiles() {
        return (MovingPercentilesAggregation)TaggedUnionUtils.get(this, Kind.MovingPercentiles);
    }

    public boolean isMovingFn() {
        return this._kind == Kind.MovingFn;
    }

    public MovingFunctionAggregation movingFn() {
        return (MovingFunctionAggregation)TaggedUnionUtils.get(this, Kind.MovingFn);
    }

    public boolean isMultiTerms() {
        return this._kind == Kind.MultiTerms;
    }

    public MultiTermsAggregation multiTerms() {
        return (MultiTermsAggregation)TaggedUnionUtils.get(this, Kind.MultiTerms);
    }

    public boolean isNested() {
        return this._kind == Kind.Nested;
    }

    public NestedAggregation nested() {
        return (NestedAggregation)TaggedUnionUtils.get(this, Kind.Nested);
    }

    public boolean isNormalize() {
        return this._kind == Kind.Normalize;
    }

    public NormalizeAggregation normalize() {
        return (NormalizeAggregation)TaggedUnionUtils.get(this, Kind.Normalize);
    }

    public boolean isParent() {
        return this._kind == Kind.Parent;
    }

    public ParentAggregation parent() {
        return (ParentAggregation)TaggedUnionUtils.get(this, Kind.Parent);
    }

    public boolean isPercentileRanks() {
        return this._kind == Kind.PercentileRanks;
    }

    public PercentileRanksAggregation percentileRanks() {
        return (PercentileRanksAggregation)TaggedUnionUtils.get(this, Kind.PercentileRanks);
    }

    public boolean isPercentiles() {
        return this._kind == Kind.Percentiles;
    }

    public PercentilesAggregation percentiles() {
        return (PercentilesAggregation)TaggedUnionUtils.get(this, Kind.Percentiles);
    }

    public boolean isPercentilesBucket() {
        return this._kind == Kind.PercentilesBucket;
    }

    public PercentilesBucketAggregation percentilesBucket() {
        return (PercentilesBucketAggregation)TaggedUnionUtils.get(this, Kind.PercentilesBucket);
    }

    public boolean isRange() {
        return this._kind == Kind.Range;
    }

    public RangeAggregation range() {
        return (RangeAggregation)TaggedUnionUtils.get(this, Kind.Range);
    }

    public boolean isRareTerms() {
        return this._kind == Kind.RareTerms;
    }

    public RareTermsAggregation rareTerms() {
        return (RareTermsAggregation)TaggedUnionUtils.get(this, Kind.RareTerms);
    }

    public boolean isRate() {
        return this._kind == Kind.Rate;
    }

    public RateAggregation rate() {
        return (RateAggregation)TaggedUnionUtils.get(this, Kind.Rate);
    }

    public boolean isReverseNested() {
        return this._kind == Kind.ReverseNested;
    }

    public ReverseNestedAggregation reverseNested() {
        return (ReverseNestedAggregation)TaggedUnionUtils.get(this, Kind.ReverseNested);
    }

    public boolean isSampler() {
        return this._kind == Kind.Sampler;
    }

    public SamplerAggregation sampler() {
        return (SamplerAggregation)TaggedUnionUtils.get(this, Kind.Sampler);
    }

    public boolean isScriptedMetric() {
        return this._kind == Kind.ScriptedMetric;
    }

    public ScriptedMetricAggregation scriptedMetric() {
        return (ScriptedMetricAggregation)TaggedUnionUtils.get(this, Kind.ScriptedMetric);
    }

    public boolean isSerialDiff() {
        return this._kind == Kind.SerialDiff;
    }

    public SerialDifferencingAggregation serialDiff() {
        return (SerialDifferencingAggregation)TaggedUnionUtils.get(this, Kind.SerialDiff);
    }

    public boolean isSignificantTerms() {
        return this._kind == Kind.SignificantTerms;
    }

    public SignificantTermsAggregation significantTerms() {
        return (SignificantTermsAggregation)TaggedUnionUtils.get(this, Kind.SignificantTerms);
    }

    public boolean isSignificantText() {
        return this._kind == Kind.SignificantText;
    }

    public SignificantTextAggregation significantText() {
        return (SignificantTextAggregation)TaggedUnionUtils.get(this, Kind.SignificantText);
    }

    public boolean isStats() {
        return this._kind == Kind.Stats;
    }

    public StatsAggregation stats() {
        return (StatsAggregation)TaggedUnionUtils.get(this, Kind.Stats);
    }

    public boolean isStatsBucket() {
        return this._kind == Kind.StatsBucket;
    }

    public StatsBucketAggregation statsBucket() {
        return (StatsBucketAggregation)TaggedUnionUtils.get(this, Kind.StatsBucket);
    }

    public boolean isStringStats() {
        return this._kind == Kind.StringStats;
    }

    public StringStatsAggregation stringStats() {
        return (StringStatsAggregation)TaggedUnionUtils.get(this, Kind.StringStats);
    }

    public boolean isSum() {
        return this._kind == Kind.Sum;
    }

    public SumAggregation sum() {
        return (SumAggregation)TaggedUnionUtils.get(this, Kind.Sum);
    }

    public boolean isSumBucket() {
        return this._kind == Kind.SumBucket;
    }

    public SumBucketAggregation sumBucket() {
        return (SumBucketAggregation)TaggedUnionUtils.get(this, Kind.SumBucket);
    }

    public boolean isTerms() {
        return this._kind == Kind.Terms;
    }

    public TermsAggregation terms() {
        return (TermsAggregation)TaggedUnionUtils.get(this, Kind.Terms);
    }

    public boolean isTopHits() {
        return this._kind == Kind.TopHits;
    }

    public TopHitsAggregation topHits() {
        return (TopHitsAggregation)TaggedUnionUtils.get(this, Kind.TopHits);
    }

    public boolean isTTest() {
        return this._kind == Kind.TTest;
    }

    public TTestAggregation tTest() {
        return (TTestAggregation)TaggedUnionUtils.get(this, Kind.TTest);
    }

    public boolean isTopMetrics() {
        return this._kind == Kind.TopMetrics;
    }

    public TopMetricsAggregation topMetrics() {
        return (TopMetricsAggregation)TaggedUnionUtils.get(this, Kind.TopMetrics);
    }

    public boolean isValueCount() {
        return this._kind == Kind.ValueCount;
    }

    public ValueCountAggregation valueCount() {
        return (ValueCountAggregation)TaggedUnionUtils.get(this, Kind.ValueCount);
    }

    public boolean isWeightedAvg() {
        return this._kind == Kind.WeightedAvg;
    }

    public WeightedAverageAggregation weightedAvg() {
        return (WeightedAverageAggregation)TaggedUnionUtils.get(this, Kind.WeightedAvg);
    }

    public boolean isVariableWidthHistogram() {
        return this._kind == Kind.VariableWidthHistogram;
    }

    public VariableWidthHistogramAggregation variableWidthHistogram() {
        return (VariableWidthHistogramAggregation)TaggedUnionUtils.get(this, Kind.VariableWidthHistogram);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(_DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "meta");
        op.add(Builder::adjacencyMatrix, AdjacencyMatrixAggregation._DESERIALIZER, "adjacency_matrix");
        op.add(Builder::autoDateHistogram, AutoDateHistogramAggregation._DESERIALIZER, "auto_date_histogram");
        op.add(Builder::avg, AverageAggregation._DESERIALIZER, "avg");
        op.add(Builder::avgBucket, AverageBucketAggregation._DESERIALIZER, "avg_bucket");
        op.add(Builder::boxplot, BoxplotAggregation._DESERIALIZER, "boxplot");
        op.add(Builder::bucketScript, BucketScriptAggregation._DESERIALIZER, "bucket_script");
        op.add(Builder::bucketSelector, BucketSelectorAggregation._DESERIALIZER, "bucket_selector");
        op.add(Builder::bucketSort, BucketSortAggregation._DESERIALIZER, "bucket_sort");
        op.add(Builder::cardinality, CardinalityAggregation._DESERIALIZER, "cardinality");
        op.add(Builder::children, ChildrenAggregation._DESERIALIZER, "children");
        op.add(Builder::composite, CompositeAggregation._DESERIALIZER, "composite");
        op.add(Builder::cumulativeCardinality, CumulativeCardinalityAggregation._DESERIALIZER, "cumulative_cardinality");
        op.add(Builder::cumulativeSum, CumulativeSumAggregation._DESERIALIZER, "cumulative_sum");
        op.add(Builder::dateHistogram, DateHistogramAggregation._DESERIALIZER, "date_histogram");
        op.add(Builder::dateRange, DateRangeAggregation._DESERIALIZER, "date_range");
        op.add(Builder::derivative, DerivativeAggregation._DESERIALIZER, "derivative");
        op.add(Builder::diversifiedSampler, DiversifiedSamplerAggregation._DESERIALIZER, "diversified_sampler");
        op.add(Builder::extendedStats, ExtendedStatsAggregation._DESERIALIZER, "extended_stats");
        op.add(Builder::extendedStatsBucket, ExtendedStatsBucketAggregation._DESERIALIZER, "extended_stats_bucket");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::filters, FiltersAggregation._DESERIALIZER, "filters");
        op.add(Builder::geoBounds, GeoBoundsAggregation._DESERIALIZER, "geo_bounds");
        op.add(Builder::geoCentroid, GeoCentroidAggregation._DESERIALIZER, "geo_centroid");
        op.add(Builder::geoDistance, GeoDistanceAggregation._DESERIALIZER, "geo_distance");
        op.add(Builder::geohashGrid, GeoHashGridAggregation._DESERIALIZER, "geohash_grid");
        op.add(Builder::geoLine, GeoLineAggregation._DESERIALIZER, "geo_line");
        op.add(Builder::geotileGrid, GeoTileGridAggregation._DESERIALIZER, "geotile_grid");
        op.add(Builder::global, GlobalAggregation._DESERIALIZER, "global");
        op.add(Builder::histogram, HistogramAggregation._DESERIALIZER, "histogram");
        op.add(Builder::ipRange, IpRangeAggregation._DESERIALIZER, "ip_range");
        op.add(Builder::inference, InferenceAggregation._DESERIALIZER, "inference");
        op.add(Builder::matrixStats, MatrixStatsAggregation._DESERIALIZER, "matrix_stats");
        op.add(Builder::max, MaxAggregation._DESERIALIZER, "max");
        op.add(Builder::maxBucket, MaxBucketAggregation._DESERIALIZER, "max_bucket");
        op.add(Builder::medianAbsoluteDeviation, MedianAbsoluteDeviationAggregation._DESERIALIZER, "median_absolute_deviation");
        op.add(Builder::min, MinAggregation._DESERIALIZER, "min");
        op.add(Builder::minBucket, MinBucketAggregation._DESERIALIZER, "min_bucket");
        op.add(Builder::missing, MissingAggregation._DESERIALIZER, "missing");
        op.add(Builder::movingAvg, MovingAverageAggregation._DESERIALIZER, "moving_avg");
        op.add(Builder::movingPercentiles, MovingPercentilesAggregation._DESERIALIZER, "moving_percentiles");
        op.add(Builder::movingFn, MovingFunctionAggregation._DESERIALIZER, "moving_fn");
        op.add(Builder::multiTerms, MultiTermsAggregation._DESERIALIZER, "multi_terms");
        op.add(Builder::nested, NestedAggregation._DESERIALIZER, "nested");
        op.add(Builder::normalize, NormalizeAggregation._DESERIALIZER, "normalize");
        op.add(Builder::parent, ParentAggregation._DESERIALIZER, "parent");
        op.add(Builder::percentileRanks, PercentileRanksAggregation._DESERIALIZER, "percentile_ranks");
        op.add(Builder::percentiles, PercentilesAggregation._DESERIALIZER, "percentiles");
        op.add(Builder::percentilesBucket, PercentilesBucketAggregation._DESERIALIZER, "percentiles_bucket");
        op.add(Builder::range, RangeAggregation._DESERIALIZER, "range");
        op.add(Builder::rareTerms, RareTermsAggregation._DESERIALIZER, "rare_terms");
        op.add(Builder::rate, RateAggregation._DESERIALIZER, "rate");
        op.add(Builder::reverseNested, ReverseNestedAggregation._DESERIALIZER, "reverse_nested");
        op.add(Builder::sampler, SamplerAggregation._DESERIALIZER, "sampler");
        op.add(Builder::scriptedMetric, ScriptedMetricAggregation._DESERIALIZER, "scripted_metric");
        op.add(Builder::serialDiff, SerialDifferencingAggregation._DESERIALIZER, "serial_diff");
        op.add(Builder::significantTerms, SignificantTermsAggregation._DESERIALIZER, "significant_terms");
        op.add(Builder::significantText, SignificantTextAggregation._DESERIALIZER, "significant_text");
        op.add(Builder::stats, StatsAggregation._DESERIALIZER, "stats");
        op.add(Builder::statsBucket, StatsBucketAggregation._DESERIALIZER, "stats_bucket");
        op.add(Builder::stringStats, StringStatsAggregation._DESERIALIZER, "string_stats");
        op.add(Builder::sum, SumAggregation._DESERIALIZER, "sum");
        op.add(Builder::sumBucket, SumBucketAggregation._DESERIALIZER, "sum_bucket");
        op.add(Builder::terms, TermsAggregation._DESERIALIZER, "terms");
        op.add(Builder::topHits, TopHitsAggregation._DESERIALIZER, "top_hits");
        op.add(Builder::tTest, TTestAggregation._DESERIALIZER, "t_test");
        op.add(Builder::topMetrics, TopMetricsAggregation._DESERIALIZER, "top_metrics");
        op.add(Builder::valueCount, ValueCountAggregation._DESERIALIZER, "value_count");
        op.add(Builder::weightedAvg, WeightedAverageAggregation._DESERIALIZER, "weighted_avg");
        op.add(Builder::variableWidthHistogram, VariableWidthHistogramAggregation._DESERIALIZER, "variable_width_histogram");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder> {
        private Kind _kind;
        private Object _value;
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Map<String, JsonData> meta;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Builder()).build());
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder adjacencyMatrix(AdjacencyMatrixAggregation v) {
            this._kind = Kind.AdjacencyMatrix;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder adjacencyMatrix(Function<AdjacencyMatrixAggregation.Builder, ObjectBuilder<AdjacencyMatrixAggregation>> fn) {
            return this.adjacencyMatrix(fn.apply(new AdjacencyMatrixAggregation.Builder()).build());
        }

        public ContainerBuilder autoDateHistogram(AutoDateHistogramAggregation v) {
            this._kind = Kind.AutoDateHistogram;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder autoDateHistogram(Function<AutoDateHistogramAggregation.Builder, ObjectBuilder<AutoDateHistogramAggregation>> fn) {
            return this.autoDateHistogram(fn.apply(new AutoDateHistogramAggregation.Builder()).build());
        }

        public ContainerBuilder avg(AverageAggregation v) {
            this._kind = Kind.Avg;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder avg(Function<AverageAggregation.Builder, ObjectBuilder<AverageAggregation>> fn) {
            return this.avg(fn.apply(new AverageAggregation.Builder()).build());
        }

        public ContainerBuilder avgBucket(AverageBucketAggregation v) {
            this._kind = Kind.AvgBucket;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder avgBucket(Function<AverageBucketAggregation.Builder, ObjectBuilder<AverageBucketAggregation>> fn) {
            return this.avgBucket(fn.apply(new AverageBucketAggregation.Builder()).build());
        }

        public ContainerBuilder boxplot(BoxplotAggregation v) {
            this._kind = Kind.Boxplot;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder boxplot(Function<BoxplotAggregation.Builder, ObjectBuilder<BoxplotAggregation>> fn) {
            return this.boxplot(fn.apply(new BoxplotAggregation.Builder()).build());
        }

        public ContainerBuilder bucketScript(BucketScriptAggregation v) {
            this._kind = Kind.BucketScript;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder bucketScript(Function<BucketScriptAggregation.Builder, ObjectBuilder<BucketScriptAggregation>> fn) {
            return this.bucketScript(fn.apply(new BucketScriptAggregation.Builder()).build());
        }

        public ContainerBuilder bucketSelector(BucketSelectorAggregation v) {
            this._kind = Kind.BucketSelector;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder bucketSelector(Function<BucketSelectorAggregation.Builder, ObjectBuilder<BucketSelectorAggregation>> fn) {
            return this.bucketSelector(fn.apply(new BucketSelectorAggregation.Builder()).build());
        }

        public ContainerBuilder bucketSort(BucketSortAggregation v) {
            this._kind = Kind.BucketSort;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder bucketSort(Function<BucketSortAggregation.Builder, ObjectBuilder<BucketSortAggregation>> fn) {
            return this.bucketSort(fn.apply(new BucketSortAggregation.Builder()).build());
        }

        public ContainerBuilder cardinality(CardinalityAggregation v) {
            this._kind = Kind.Cardinality;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder cardinality(Function<CardinalityAggregation.Builder, ObjectBuilder<CardinalityAggregation>> fn) {
            return this.cardinality(fn.apply(new CardinalityAggregation.Builder()).build());
        }

        public ContainerBuilder children(ChildrenAggregation v) {
            this._kind = Kind.Children;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder children(Function<ChildrenAggregation.Builder, ObjectBuilder<ChildrenAggregation>> fn) {
            return this.children(fn.apply(new ChildrenAggregation.Builder()).build());
        }

        public ContainerBuilder composite(CompositeAggregation v) {
            this._kind = Kind.Composite;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder composite(Function<CompositeAggregation.Builder, ObjectBuilder<CompositeAggregation>> fn) {
            return this.composite(fn.apply(new CompositeAggregation.Builder()).build());
        }

        public ContainerBuilder cumulativeCardinality(CumulativeCardinalityAggregation v) {
            this._kind = Kind.CumulativeCardinality;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder cumulativeCardinality(Function<CumulativeCardinalityAggregation.Builder, ObjectBuilder<CumulativeCardinalityAggregation>> fn) {
            return this.cumulativeCardinality(fn.apply(new CumulativeCardinalityAggregation.Builder()).build());
        }

        public ContainerBuilder cumulativeSum(CumulativeSumAggregation v) {
            this._kind = Kind.CumulativeSum;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder cumulativeSum(Function<CumulativeSumAggregation.Builder, ObjectBuilder<CumulativeSumAggregation>> fn) {
            return this.cumulativeSum(fn.apply(new CumulativeSumAggregation.Builder()).build());
        }

        public ContainerBuilder dateHistogram(DateHistogramAggregation v) {
            this._kind = Kind.DateHistogram;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder dateHistogram(Function<DateHistogramAggregation.Builder, ObjectBuilder<DateHistogramAggregation>> fn) {
            return this.dateHistogram(fn.apply(new DateHistogramAggregation.Builder()).build());
        }

        public ContainerBuilder dateRange(DateRangeAggregation v) {
            this._kind = Kind.DateRange;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder dateRange(Function<DateRangeAggregation.Builder, ObjectBuilder<DateRangeAggregation>> fn) {
            return this.dateRange(fn.apply(new DateRangeAggregation.Builder()).build());
        }

        public ContainerBuilder derivative(DerivativeAggregation v) {
            this._kind = Kind.Derivative;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder derivative(Function<DerivativeAggregation.Builder, ObjectBuilder<DerivativeAggregation>> fn) {
            return this.derivative(fn.apply(new DerivativeAggregation.Builder()).build());
        }

        public ContainerBuilder diversifiedSampler(DiversifiedSamplerAggregation v) {
            this._kind = Kind.DiversifiedSampler;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder diversifiedSampler(Function<DiversifiedSamplerAggregation.Builder, ObjectBuilder<DiversifiedSamplerAggregation>> fn) {
            return this.diversifiedSampler(fn.apply(new DiversifiedSamplerAggregation.Builder()).build());
        }

        public ContainerBuilder extendedStats(ExtendedStatsAggregation v) {
            this._kind = Kind.ExtendedStats;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder extendedStats(Function<ExtendedStatsAggregation.Builder, ObjectBuilder<ExtendedStatsAggregation>> fn) {
            return this.extendedStats(fn.apply(new ExtendedStatsAggregation.Builder()).build());
        }

        public ContainerBuilder extendedStatsBucket(ExtendedStatsBucketAggregation v) {
            this._kind = Kind.ExtendedStatsBucket;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder extendedStatsBucket(Function<ExtendedStatsBucketAggregation.Builder, ObjectBuilder<ExtendedStatsBucketAggregation>> fn) {
            return this.extendedStatsBucket(fn.apply(new ExtendedStatsBucketAggregation.Builder()).build());
        }

        public ContainerBuilder filter(Query v) {
            this._kind = Kind.Filter;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public ContainerBuilder filters(FiltersAggregation v) {
            this._kind = Kind.Filters;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder filters(Function<FiltersAggregation.Builder, ObjectBuilder<FiltersAggregation>> fn) {
            return this.filters(fn.apply(new FiltersAggregation.Builder()).build());
        }

        public ContainerBuilder geoBounds(GeoBoundsAggregation v) {
            this._kind = Kind.GeoBounds;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geoBounds(Function<GeoBoundsAggregation.Builder, ObjectBuilder<GeoBoundsAggregation>> fn) {
            return this.geoBounds(fn.apply(new GeoBoundsAggregation.Builder()).build());
        }

        public ContainerBuilder geoCentroid(GeoCentroidAggregation v) {
            this._kind = Kind.GeoCentroid;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geoCentroid(Function<GeoCentroidAggregation.Builder, ObjectBuilder<GeoCentroidAggregation>> fn) {
            return this.geoCentroid(fn.apply(new GeoCentroidAggregation.Builder()).build());
        }

        public ContainerBuilder geoDistance(GeoDistanceAggregation v) {
            this._kind = Kind.GeoDistance;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geoDistance(Function<GeoDistanceAggregation.Builder, ObjectBuilder<GeoDistanceAggregation>> fn) {
            return this.geoDistance(fn.apply(new GeoDistanceAggregation.Builder()).build());
        }

        public ContainerBuilder geohashGrid(GeoHashGridAggregation v) {
            this._kind = Kind.GeohashGrid;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geohashGrid(Function<GeoHashGridAggregation.Builder, ObjectBuilder<GeoHashGridAggregation>> fn) {
            return this.geohashGrid(fn.apply(new GeoHashGridAggregation.Builder()).build());
        }

        public ContainerBuilder geoLine(GeoLineAggregation v) {
            this._kind = Kind.GeoLine;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geoLine(Function<GeoLineAggregation.Builder, ObjectBuilder<GeoLineAggregation>> fn) {
            return this.geoLine(fn.apply(new GeoLineAggregation.Builder()).build());
        }

        public ContainerBuilder geotileGrid(GeoTileGridAggregation v) {
            this._kind = Kind.GeotileGrid;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder geotileGrid(Function<GeoTileGridAggregation.Builder, ObjectBuilder<GeoTileGridAggregation>> fn) {
            return this.geotileGrid(fn.apply(new GeoTileGridAggregation.Builder()).build());
        }

        public ContainerBuilder global(GlobalAggregation v) {
            this._kind = Kind.Global;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder global(Function<GlobalAggregation.Builder, ObjectBuilder<GlobalAggregation>> fn) {
            return this.global(fn.apply(new GlobalAggregation.Builder()).build());
        }

        public ContainerBuilder histogram(HistogramAggregation v) {
            this._kind = Kind.Histogram;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder histogram(Function<HistogramAggregation.Builder, ObjectBuilder<HistogramAggregation>> fn) {
            return this.histogram(fn.apply(new HistogramAggregation.Builder()).build());
        }

        public ContainerBuilder ipRange(IpRangeAggregation v) {
            this._kind = Kind.IpRange;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder ipRange(Function<IpRangeAggregation.Builder, ObjectBuilder<IpRangeAggregation>> fn) {
            return this.ipRange(fn.apply(new IpRangeAggregation.Builder()).build());
        }

        public ContainerBuilder inference(InferenceAggregation v) {
            this._kind = Kind.Inference;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder inference(Function<InferenceAggregation.Builder, ObjectBuilder<InferenceAggregation>> fn) {
            return this.inference(fn.apply(new InferenceAggregation.Builder()).build());
        }

        public ContainerBuilder matrixStats(MatrixStatsAggregation v) {
            this._kind = Kind.MatrixStats;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder matrixStats(Function<MatrixStatsAggregation.Builder, ObjectBuilder<MatrixStatsAggregation>> fn) {
            return this.matrixStats(fn.apply(new MatrixStatsAggregation.Builder()).build());
        }

        public ContainerBuilder max(MaxAggregation v) {
            this._kind = Kind.Max;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder max(Function<MaxAggregation.Builder, ObjectBuilder<MaxAggregation>> fn) {
            return this.max(fn.apply(new MaxAggregation.Builder()).build());
        }

        public ContainerBuilder maxBucket(MaxBucketAggregation v) {
            this._kind = Kind.MaxBucket;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder maxBucket(Function<MaxBucketAggregation.Builder, ObjectBuilder<MaxBucketAggregation>> fn) {
            return this.maxBucket(fn.apply(new MaxBucketAggregation.Builder()).build());
        }

        public ContainerBuilder medianAbsoluteDeviation(MedianAbsoluteDeviationAggregation v) {
            this._kind = Kind.MedianAbsoluteDeviation;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder medianAbsoluteDeviation(Function<MedianAbsoluteDeviationAggregation.Builder, ObjectBuilder<MedianAbsoluteDeviationAggregation>> fn) {
            return this.medianAbsoluteDeviation(fn.apply(new MedianAbsoluteDeviationAggregation.Builder()).build());
        }

        public ContainerBuilder min(MinAggregation v) {
            this._kind = Kind.Min;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder min(Function<MinAggregation.Builder, ObjectBuilder<MinAggregation>> fn) {
            return this.min(fn.apply(new MinAggregation.Builder()).build());
        }

        public ContainerBuilder minBucket(MinBucketAggregation v) {
            this._kind = Kind.MinBucket;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder minBucket(Function<MinBucketAggregation.Builder, ObjectBuilder<MinBucketAggregation>> fn) {
            return this.minBucket(fn.apply(new MinBucketAggregation.Builder()).build());
        }

        public ContainerBuilder missing(MissingAggregation v) {
            this._kind = Kind.Missing;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder missing(Function<MissingAggregation.Builder, ObjectBuilder<MissingAggregation>> fn) {
            return this.missing(fn.apply(new MissingAggregation.Builder()).build());
        }

        public ContainerBuilder movingAvg(MovingAverageAggregation v) {
            this._kind = Kind.MovingAvg;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder movingAvg(Function<MovingAverageAggregation.Builder, ObjectBuilder<MovingAverageAggregation>> fn) {
            return this.movingAvg(fn.apply(new MovingAverageAggregation.Builder()).build());
        }

        public ContainerBuilder movingPercentiles(MovingPercentilesAggregation v) {
            this._kind = Kind.MovingPercentiles;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder movingPercentiles(Function<MovingPercentilesAggregation.Builder, ObjectBuilder<MovingPercentilesAggregation>> fn) {
            return this.movingPercentiles(fn.apply(new MovingPercentilesAggregation.Builder()).build());
        }

        public ContainerBuilder movingFn(MovingFunctionAggregation v) {
            this._kind = Kind.MovingFn;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder movingFn(Function<MovingFunctionAggregation.Builder, ObjectBuilder<MovingFunctionAggregation>> fn) {
            return this.movingFn(fn.apply(new MovingFunctionAggregation.Builder()).build());
        }

        public ContainerBuilder multiTerms(MultiTermsAggregation v) {
            this._kind = Kind.MultiTerms;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder multiTerms(Function<MultiTermsAggregation.Builder, ObjectBuilder<MultiTermsAggregation>> fn) {
            return this.multiTerms(fn.apply(new MultiTermsAggregation.Builder()).build());
        }

        public ContainerBuilder nested(NestedAggregation v) {
            this._kind = Kind.Nested;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder nested(Function<NestedAggregation.Builder, ObjectBuilder<NestedAggregation>> fn) {
            return this.nested(fn.apply(new NestedAggregation.Builder()).build());
        }

        public ContainerBuilder normalize(NormalizeAggregation v) {
            this._kind = Kind.Normalize;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder normalize(Function<NormalizeAggregation.Builder, ObjectBuilder<NormalizeAggregation>> fn) {
            return this.normalize(fn.apply(new NormalizeAggregation.Builder()).build());
        }

        public ContainerBuilder parent(ParentAggregation v) {
            this._kind = Kind.Parent;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder parent(Function<ParentAggregation.Builder, ObjectBuilder<ParentAggregation>> fn) {
            return this.parent(fn.apply(new ParentAggregation.Builder()).build());
        }

        public ContainerBuilder percentileRanks(PercentileRanksAggregation v) {
            this._kind = Kind.PercentileRanks;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder percentileRanks(Function<PercentileRanksAggregation.Builder, ObjectBuilder<PercentileRanksAggregation>> fn) {
            return this.percentileRanks(fn.apply(new PercentileRanksAggregation.Builder()).build());
        }

        public ContainerBuilder percentiles(PercentilesAggregation v) {
            this._kind = Kind.Percentiles;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder percentiles(Function<PercentilesAggregation.Builder, ObjectBuilder<PercentilesAggregation>> fn) {
            return this.percentiles(fn.apply(new PercentilesAggregation.Builder()).build());
        }

        public ContainerBuilder percentilesBucket(PercentilesBucketAggregation v) {
            this._kind = Kind.PercentilesBucket;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder percentilesBucket(Function<PercentilesBucketAggregation.Builder, ObjectBuilder<PercentilesBucketAggregation>> fn) {
            return this.percentilesBucket(fn.apply(new PercentilesBucketAggregation.Builder()).build());
        }

        public ContainerBuilder range(RangeAggregation v) {
            this._kind = Kind.Range;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder range(Function<RangeAggregation.Builder, ObjectBuilder<RangeAggregation>> fn) {
            return this.range(fn.apply(new RangeAggregation.Builder()).build());
        }

        public ContainerBuilder rareTerms(RareTermsAggregation v) {
            this._kind = Kind.RareTerms;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder rareTerms(Function<RareTermsAggregation.Builder, ObjectBuilder<RareTermsAggregation>> fn) {
            return this.rareTerms(fn.apply(new RareTermsAggregation.Builder()).build());
        }

        public ContainerBuilder rate(RateAggregation v) {
            this._kind = Kind.Rate;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder rate(Function<RateAggregation.Builder, ObjectBuilder<RateAggregation>> fn) {
            return this.rate(fn.apply(new RateAggregation.Builder()).build());
        }

        public ContainerBuilder reverseNested(ReverseNestedAggregation v) {
            this._kind = Kind.ReverseNested;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder reverseNested(Function<ReverseNestedAggregation.Builder, ObjectBuilder<ReverseNestedAggregation>> fn) {
            return this.reverseNested(fn.apply(new ReverseNestedAggregation.Builder()).build());
        }

        public ContainerBuilder sampler(SamplerAggregation v) {
            this._kind = Kind.Sampler;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder sampler(Function<SamplerAggregation.Builder, ObjectBuilder<SamplerAggregation>> fn) {
            return this.sampler(fn.apply(new SamplerAggregation.Builder()).build());
        }

        public ContainerBuilder scriptedMetric(ScriptedMetricAggregation v) {
            this._kind = Kind.ScriptedMetric;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder scriptedMetric(Function<ScriptedMetricAggregation.Builder, ObjectBuilder<ScriptedMetricAggregation>> fn) {
            return this.scriptedMetric(fn.apply(new ScriptedMetricAggregation.Builder()).build());
        }

        public ContainerBuilder serialDiff(SerialDifferencingAggregation v) {
            this._kind = Kind.SerialDiff;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder serialDiff(Function<SerialDifferencingAggregation.Builder, ObjectBuilder<SerialDifferencingAggregation>> fn) {
            return this.serialDiff(fn.apply(new SerialDifferencingAggregation.Builder()).build());
        }

        public ContainerBuilder significantTerms(SignificantTermsAggregation v) {
            this._kind = Kind.SignificantTerms;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder significantTerms(Function<SignificantTermsAggregation.Builder, ObjectBuilder<SignificantTermsAggregation>> fn) {
            return this.significantTerms(fn.apply(new SignificantTermsAggregation.Builder()).build());
        }

        public ContainerBuilder significantText(SignificantTextAggregation v) {
            this._kind = Kind.SignificantText;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder significantText(Function<SignificantTextAggregation.Builder, ObjectBuilder<SignificantTextAggregation>> fn) {
            return this.significantText(fn.apply(new SignificantTextAggregation.Builder()).build());
        }

        public ContainerBuilder stats(StatsAggregation v) {
            this._kind = Kind.Stats;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder stats(Function<StatsAggregation.Builder, ObjectBuilder<StatsAggregation>> fn) {
            return this.stats(fn.apply(new StatsAggregation.Builder()).build());
        }

        public ContainerBuilder statsBucket(StatsBucketAggregation v) {
            this._kind = Kind.StatsBucket;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder statsBucket(Function<StatsBucketAggregation.Builder, ObjectBuilder<StatsBucketAggregation>> fn) {
            return this.statsBucket(fn.apply(new StatsBucketAggregation.Builder()).build());
        }

        public ContainerBuilder stringStats(StringStatsAggregation v) {
            this._kind = Kind.StringStats;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder stringStats(Function<StringStatsAggregation.Builder, ObjectBuilder<StringStatsAggregation>> fn) {
            return this.stringStats(fn.apply(new StringStatsAggregation.Builder()).build());
        }

        public ContainerBuilder sum(SumAggregation v) {
            this._kind = Kind.Sum;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder sum(Function<SumAggregation.Builder, ObjectBuilder<SumAggregation>> fn) {
            return this.sum(fn.apply(new SumAggregation.Builder()).build());
        }

        public ContainerBuilder sumBucket(SumBucketAggregation v) {
            this._kind = Kind.SumBucket;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder sumBucket(Function<SumBucketAggregation.Builder, ObjectBuilder<SumBucketAggregation>> fn) {
            return this.sumBucket(fn.apply(new SumBucketAggregation.Builder()).build());
        }

        public ContainerBuilder terms(TermsAggregation v) {
            this._kind = Kind.Terms;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder terms(Function<TermsAggregation.Builder, ObjectBuilder<TermsAggregation>> fn) {
            return this.terms(fn.apply(new TermsAggregation.Builder()).build());
        }

        public ContainerBuilder topHits(TopHitsAggregation v) {
            this._kind = Kind.TopHits;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder topHits(Function<TopHitsAggregation.Builder, ObjectBuilder<TopHitsAggregation>> fn) {
            return this.topHits(fn.apply(new TopHitsAggregation.Builder()).build());
        }

        public ContainerBuilder tTest(TTestAggregation v) {
            this._kind = Kind.TTest;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder tTest(Function<TTestAggregation.Builder, ObjectBuilder<TTestAggregation>> fn) {
            return this.tTest(fn.apply(new TTestAggregation.Builder()).build());
        }

        public ContainerBuilder topMetrics(TopMetricsAggregation v) {
            this._kind = Kind.TopMetrics;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder topMetrics(Function<TopMetricsAggregation.Builder, ObjectBuilder<TopMetricsAggregation>> fn) {
            return this.topMetrics(fn.apply(new TopMetricsAggregation.Builder()).build());
        }

        public ContainerBuilder valueCount(ValueCountAggregation v) {
            this._kind = Kind.ValueCount;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder valueCount(Function<ValueCountAggregation.Builder, ObjectBuilder<ValueCountAggregation>> fn) {
            return this.valueCount(fn.apply(new ValueCountAggregation.Builder()).build());
        }

        public ContainerBuilder weightedAvg(WeightedAverageAggregation v) {
            this._kind = Kind.WeightedAvg;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder weightedAvg(Function<WeightedAverageAggregation.Builder, ObjectBuilder<WeightedAverageAggregation>> fn) {
            return this.weightedAvg(fn.apply(new WeightedAverageAggregation.Builder()).build());
        }

        public ContainerBuilder variableWidthHistogram(VariableWidthHistogramAggregation v) {
            this._kind = Kind.VariableWidthHistogram;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder variableWidthHistogram(Function<VariableWidthHistogramAggregation.Builder, ObjectBuilder<VariableWidthHistogramAggregation>> fn) {
            return this.variableWidthHistogram(fn.apply(new VariableWidthHistogramAggregation.Builder()).build());
        }

        protected Aggregation build() {
            this._checkSingleUse();
            return new Aggregation(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<Aggregation> {
            public final ContainerBuilder aggregations(Map<String, Aggregation> map) {
                Builder.this.aggregations = Builder._mapPutAll(Builder.this.aggregations, map);
                return this;
            }

            public final ContainerBuilder aggregations(String key, Aggregation value) {
                Builder.this.aggregations = Builder._mapPut(Builder.this.aggregations, key, value);
                return this;
            }

            public final ContainerBuilder aggregations(String key, Function<Builder, ObjectBuilder<Aggregation>> fn) {
                return this.aggregations(key, fn.apply(new Builder()).build());
            }

            public final ContainerBuilder meta(Map<String, JsonData> map) {
                Builder.this.meta = Builder._mapPutAll(Builder.this.meta, map);
                return this;
            }

            public final ContainerBuilder meta(String key, JsonData value) {
                Builder.this.meta = Builder._mapPut(Builder.this.meta, key, value);
                return this;
            }

            @Override
            public Aggregation build() {
                return Builder.this.build();
            }
        }
    }

    public static enum Kind implements JsonEnum
    {
        AdjacencyMatrix("adjacency_matrix"),
        AutoDateHistogram("auto_date_histogram"),
        Avg("avg"),
        AvgBucket("avg_bucket"),
        Boxplot("boxplot"),
        BucketScript("bucket_script"),
        BucketSelector("bucket_selector"),
        BucketSort("bucket_sort"),
        Cardinality("cardinality"),
        Children("children"),
        Composite("composite"),
        CumulativeCardinality("cumulative_cardinality"),
        CumulativeSum("cumulative_sum"),
        DateHistogram("date_histogram"),
        DateRange("date_range"),
        Derivative("derivative"),
        DiversifiedSampler("diversified_sampler"),
        ExtendedStats("extended_stats"),
        ExtendedStatsBucket("extended_stats_bucket"),
        Filter("filter"),
        Filters("filters"),
        GeoBounds("geo_bounds"),
        GeoCentroid("geo_centroid"),
        GeoDistance("geo_distance"),
        GeohashGrid("geohash_grid"),
        GeoLine("geo_line"),
        GeotileGrid("geotile_grid"),
        Global("global"),
        Histogram("histogram"),
        IpRange("ip_range"),
        Inference("inference"),
        MatrixStats("matrix_stats"),
        Max("max"),
        MaxBucket("max_bucket"),
        MedianAbsoluteDeviation("median_absolute_deviation"),
        Min("min"),
        MinBucket("min_bucket"),
        Missing("missing"),
        MovingAvg("moving_avg"),
        MovingPercentiles("moving_percentiles"),
        MovingFn("moving_fn"),
        MultiTerms("multi_terms"),
        Nested("nested"),
        Normalize("normalize"),
        Parent("parent"),
        PercentileRanks("percentile_ranks"),
        Percentiles("percentiles"),
        PercentilesBucket("percentiles_bucket"),
        Range("range"),
        RareTerms("rare_terms"),
        Rate("rate"),
        ReverseNested("reverse_nested"),
        Sampler("sampler"),
        ScriptedMetric("scripted_metric"),
        SerialDiff("serial_diff"),
        SignificantTerms("significant_terms"),
        SignificantText("significant_text"),
        Stats("stats"),
        StatsBucket("stats_bucket"),
        StringStats("string_stats"),
        Sum("sum"),
        SumBucket("sum_bucket"),
        Terms("terms"),
        TopHits("top_hits"),
        TTest("t_test"),
        TopMetrics("top_metrics"),
        ValueCount("value_count"),
        WeightedAvg("weighted_avg"),
        VariableWidthHistogram("variable_width_histogram");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

