/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.elasticsearch.transform.get_transform_stats.TransformProgress;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CheckpointStats
implements JsonpSerializable {
    private final long checkpoint;
    @Nullable
    private final TransformProgress checkpointProgress;
    @Nullable
    private final String timestamp;
    private final String timestampMillis;
    @Nullable
    private final String timeUpperBound;
    @Nullable
    private final String timeUpperBoundMillis;
    public static final JsonpDeserializer<CheckpointStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CheckpointStats::setupCheckpointStatsDeserializer);

    private CheckpointStats(Builder builder) {
        this.checkpoint = ApiTypeHelper.requireNonNull(builder.checkpoint, this, "checkpoint");
        this.checkpointProgress = builder.checkpointProgress;
        this.timestamp = builder.timestamp;
        this.timestampMillis = ApiTypeHelper.requireNonNull(builder.timestampMillis, this, "timestampMillis");
        this.timeUpperBound = builder.timeUpperBound;
        this.timeUpperBoundMillis = builder.timeUpperBoundMillis;
    }

    public static CheckpointStats of(Function<Builder, ObjectBuilder<CheckpointStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long checkpoint() {
        return this.checkpoint;
    }

    @Nullable
    public final TransformProgress checkpointProgress() {
        return this.checkpointProgress;
    }

    @Nullable
    public final String timestamp() {
        return this.timestamp;
    }

    public final String timestampMillis() {
        return this.timestampMillis;
    }

    @Nullable
    public final String timeUpperBound() {
        return this.timeUpperBound;
    }

    @Nullable
    public final String timeUpperBoundMillis() {
        return this.timeUpperBoundMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("checkpoint");
        generator.write(this.checkpoint);
        if (this.checkpointProgress != null) {
            generator.writeKey("checkpoint_progress");
            this.checkpointProgress.serialize(generator, mapper);
        }
        if (this.timestamp != null) {
            generator.writeKey("timestamp");
            generator.write(this.timestamp);
        }
        generator.writeKey("timestamp_millis");
        generator.write(this.timestampMillis);
        if (this.timeUpperBound != null) {
            generator.writeKey("time_upper_bound");
            generator.write(this.timeUpperBound);
        }
        if (this.timeUpperBoundMillis != null) {
            generator.writeKey("time_upper_bound_millis");
            generator.write(this.timeUpperBoundMillis);
        }
    }

    protected static void setupCheckpointStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::checkpoint, JsonpDeserializer.longDeserializer(), "checkpoint");
        op.add(Builder::checkpointProgress, TransformProgress._DESERIALIZER, "checkpoint_progress");
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp");
        op.add(Builder::timestampMillis, JsonpDeserializer.stringDeserializer(), "timestamp_millis");
        op.add(Builder::timeUpperBound, JsonpDeserializer.stringDeserializer(), "time_upper_bound");
        op.add(Builder::timeUpperBoundMillis, JsonpDeserializer.stringDeserializer(), "time_upper_bound_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CheckpointStats> {
        private Long checkpoint;
        @Nullable
        private TransformProgress checkpointProgress;
        @Nullable
        private String timestamp;
        private String timestampMillis;
        @Nullable
        private String timeUpperBound;
        @Nullable
        private String timeUpperBoundMillis;

        public final Builder checkpoint(long value) {
            this.checkpoint = value;
            return this;
        }

        public final Builder checkpointProgress(@Nullable TransformProgress value) {
            this.checkpointProgress = value;
            return this;
        }

        public final Builder checkpointProgress(Function<TransformProgress.Builder, ObjectBuilder<TransformProgress>> fn) {
            return this.checkpointProgress(fn.apply(new TransformProgress.Builder()).build());
        }

        public final Builder timestamp(@Nullable String value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timestampMillis(String value) {
            this.timestampMillis = value;
            return this;
        }

        public final Builder timeUpperBound(@Nullable String value) {
            this.timeUpperBound = value;
            return this;
        }

        public final Builder timeUpperBoundMillis(@Nullable String value) {
            this.timeUpperBoundMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CheckpointStats build() {
            this._checkSingleUse();
            return new CheckpointStats(this);
        }
    }
}

