/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_jobs;

import co.elastic.clients.elasticsearch.rollup.get_jobs.IndexingJobState;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RollupJobStatus
implements JsonpSerializable {
    private final Map<String, JsonData> currentPosition;
    private final IndexingJobState jobState;
    @Nullable
    private final Boolean upgradedDocId;
    public static final JsonpDeserializer<RollupJobStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJobStatus::setupRollupJobStatusDeserializer);

    private RollupJobStatus(Builder builder) {
        this.currentPosition = ApiTypeHelper.unmodifiable(builder.currentPosition);
        this.jobState = ApiTypeHelper.requireNonNull(builder.jobState, this, "jobState");
        this.upgradedDocId = builder.upgradedDocId;
    }

    public static RollupJobStatus of(Function<Builder, ObjectBuilder<RollupJobStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> currentPosition() {
        return this.currentPosition;
    }

    public final IndexingJobState jobState() {
        return this.jobState;
    }

    @Nullable
    public final Boolean upgradedDocId() {
        return this.upgradedDocId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.currentPosition)) {
            generator.writeKey("current_position");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.currentPosition.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("job_state");
        this.jobState.serialize(generator, mapper);
        if (this.upgradedDocId != null) {
            generator.writeKey("upgraded_doc_id");
            generator.write(this.upgradedDocId.booleanValue());
        }
    }

    protected static void setupRollupJobStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentPosition, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "current_position");
        op.add(Builder::jobState, IndexingJobState._DESERIALIZER, "job_state");
        op.add(Builder::upgradedDocId, JsonpDeserializer.booleanDeserializer(), "upgraded_doc_id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RollupJobStatus> {
        @Nullable
        private Map<String, JsonData> currentPosition;
        private IndexingJobState jobState;
        @Nullable
        private Boolean upgradedDocId;

        public final Builder currentPosition(Map<String, JsonData> map) {
            this.currentPosition = Builder._mapPutAll(this.currentPosition, map);
            return this;
        }

        public final Builder currentPosition(String key, JsonData value) {
            this.currentPosition = Builder._mapPut(this.currentPosition, key, value);
            return this;
        }

        public final Builder jobState(IndexingJobState value) {
            this.jobState = value;
            return this;
        }

        public final Builder upgradedDocId(@Nullable Boolean value) {
            this.upgradedDocId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RollupJobStatus build() {
            this._checkSingleUse();
            return new RollupJobStatus(this);
        }
    }
}

