/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch._types.TransformVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class ScriptTransform
implements TransformVariant,
JsonpSerializable {
    private final String lang;
    private final Map<String, JsonData> params;
    public static final JsonpDeserializer<ScriptTransform> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptTransform::setupScriptTransformDeserializer);

    private ScriptTransform(Builder builder) {
        this.lang = ApiTypeHelper.requireNonNull(builder.lang, this, "lang");
        this.params = ApiTypeHelper.unmodifiableRequired(builder.params, (Object)this, "params");
    }

    public static ScriptTransform of(Function<Builder, ObjectBuilder<ScriptTransform>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Transform.Kind _transformKind() {
        return Transform.Kind.Script;
    }

    public final String lang() {
        return this.lang;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lang");
        generator.write(this.lang);
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupScriptTransformDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ScriptTransform> {
        private String lang;
        private Map<String, JsonData> params;

        public final Builder lang(String value) {
            this.lang = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptTransform build() {
            this._checkSingleUse();
            return new ScriptTransform(this);
        }
    }
}

