/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.AggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.BucketsPath;
import co.elastic.clients.elasticsearch._types.aggregations.GapPolicy;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class PipelineAggregationBase
extends AggregationBase {
    @Nullable
    private final BucketsPath bucketsPath;
    @Nullable
    private final String format;
    @Nullable
    private final GapPolicy gapPolicy;

    protected PipelineAggregationBase(AbstractBuilder<?> builder) {
        super(builder);
        this.bucketsPath = ((AbstractBuilder)builder).bucketsPath;
        this.format = ((AbstractBuilder)builder).format;
        this.gapPolicy = ((AbstractBuilder)builder).gapPolicy;
    }

    @Nullable
    public final BucketsPath bucketsPath() {
        return this.bucketsPath;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bucketsPath != null) {
            generator.writeKey("buckets_path");
            this.bucketsPath.serialize(generator, mapper);
        }
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.gapPolicy != null) {
            generator.writeKey("gap_policy");
            this.gapPolicy.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPipelineAggregationBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        AggregationBase.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::bucketsPath, BucketsPath._DESERIALIZER, "buckets_path");
        op.add(AbstractBuilder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(AbstractBuilder::gapPolicy, GapPolicy._DESERIALIZER, "gap_policy");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private BucketsPath bucketsPath;
        @Nullable
        private String format;
        @Nullable
        private GapPolicy gapPolicy;

        public final BuilderT bucketsPath(@Nullable BucketsPath value) {
            this.bucketsPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT bucketsPath(Function<BucketsPath.Builder, ObjectBuilder<BucketsPath>> fn) {
            return this.bucketsPath(fn.apply(new BucketsPath.Builder()).build());
        }

        public final BuilderT format(@Nullable String value) {
            this.format = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT gapPolicy(@Nullable GapPolicy value) {
            this.gapPolicy = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

