/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.ResetJobResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ResetJobRequest
extends RequestBase {
    private final String jobId;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<ResetJobRequest, ResetJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ResetJobRequest, ResetJobResponse>("es/ml.reset_job", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_reset");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ResetJobResponse._DESERIALIZER);

    private ResetJobRequest(Builder builder) {
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static ResetJobRequest of(Function<Builder, ObjectBuilder<ResetJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ResetJobRequest> {
        private String jobId;
        @Nullable
        private Boolean waitForCompletion;

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ResetJobRequest build() {
            this._checkSingleUse();
            return new ResetJobRequest(this);
        }
    }
}

