/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.monitoring;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BulkResponse
implements JsonpSerializable {
    @Nullable
    private final ErrorCause error;
    private final boolean errors;
    private final boolean ignored;
    private final long took;
    public static final JsonpDeserializer<BulkResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BulkResponse::setupBulkResponseDeserializer);

    private BulkResponse(Builder builder) {
        this.error = builder.error;
        this.errors = ApiTypeHelper.requireNonNull(builder.errors, this, "errors");
        this.ignored = ApiTypeHelper.requireNonNull(builder.ignored, this, "ignored");
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
    }

    public static BulkResponse of(Function<Builder, ObjectBuilder<BulkResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    public final boolean errors() {
        return this.errors;
    }

    public final boolean ignored() {
        return this.ignored;
    }

    public final long took() {
        return this.took;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
        generator.writeKey("errors");
        generator.write(this.errors);
        generator.writeKey("ignored");
        generator.write(this.ignored);
        generator.writeKey("took");
        generator.write(this.took);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupBulkResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
        op.add(Builder::errors, JsonpDeserializer.booleanDeserializer(), "errors");
        op.add(Builder::ignored, JsonpDeserializer.booleanDeserializer(), "ignored");
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BulkResponse> {
        @Nullable
        private ErrorCause error;
        private Boolean errors;
        private Boolean ignored;
        private Long took;

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder errors(boolean value) {
            this.errors = value;
            return this;
        }

        public final Builder ignored(boolean value) {
            this.ignored = value;
            return this;
        }

        public final Builder took(long value) {
            this.took = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BulkResponse build() {
            this._checkSingleUse();
            return new BulkResponse(this);
        }
    }
}

