/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.BuiltinHighlighterType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class HighlighterType
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<HighlighterType> _DESERIALIZER = JsonpDeserializer.lazy(HighlighterType::buildHighlighterTypeDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private HighlighterType(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Builtin: {
                return this.builtin().jsonValue();
            }
            case Custom: {
                return this.custom();
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    private HighlighterType(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static HighlighterType of(Function<Builder, ObjectBuilder<HighlighterType>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isBuiltin() {
        return this._kind == Kind.Builtin;
    }

    public BuiltinHighlighterType builtin() {
        return (BuiltinHighlighterType)TaggedUnionUtils.get(this, Kind.Builtin);
    }

    public boolean isCustom() {
        return this._kind == Kind.Custom;
    }

    public String custom() {
        return (String)TaggedUnionUtils.get(this, Kind.Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Custom: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    private static JsonpDeserializer<HighlighterType> buildHighlighterTypeDeserializer() {
        return new UnionDeserializer.Builder<HighlighterType, Kind, Object>(HighlighterType::new, true).addMember(Kind.Builtin, BuiltinHighlighterType._DESERIALIZER).addMember(Kind.Custom, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HighlighterType> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<HighlighterType> builtin(BuiltinHighlighterType v) {
            this._kind = Kind.Builtin;
            this._value = v;
            return this;
        }

        public ObjectBuilder<HighlighterType> custom(String v) {
            this._kind = Kind.Custom;
            this._value = v;
            return this;
        }

        @Override
        public HighlighterType build() {
            this._checkSingleUse();
            return new HighlighterType(this);
        }
    }

    public static enum Kind {
        Builtin,
        Custom;

    }
}

