/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class WatcherActionTotals
implements JsonpSerializable {
    private final long total;
    private final long totalTimeInMs;
    public static final JsonpDeserializer<WatcherActionTotals> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherActionTotals::setupWatcherActionTotalsDeserializer);

    private WatcherActionTotals(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.totalTimeInMs = ApiTypeHelper.requireNonNull(builder.totalTimeInMs, this, "totalTimeInMs");
    }

    public static WatcherActionTotals of(Function<Builder, ObjectBuilder<WatcherActionTotals>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long total() {
        return this.total;
    }

    public final long totalTimeInMs() {
        return this.totalTimeInMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_time_in_ms");
        generator.write(this.totalTimeInMs);
    }

    protected static void setupWatcherActionTotalsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::totalTimeInMs, JsonpDeserializer.longDeserializer(), "total_time_in_ms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WatcherActionTotals> {
        private Long total;
        private Long totalTimeInMs;

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder totalTimeInMs(long value) {
            this.totalTimeInMs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatcherActionTotals build() {
            this._checkSingleUse();
            return new WatcherActionTotals(this);
        }
    }
}

