/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ApplicationPrivileges
implements JsonpSerializable {
    private final String application;
    private final List<String> privileges;
    private final List<String> resources;
    public static final JsonpDeserializer<ApplicationPrivileges> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApplicationPrivileges::setupApplicationPrivilegesDeserializer);

    private ApplicationPrivileges(Builder builder) {
        this.application = ApiTypeHelper.requireNonNull(builder.application, this, "application");
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
        this.resources = ApiTypeHelper.unmodifiableRequired(builder.resources, (Object)this, "resources");
    }

    public static ApplicationPrivileges of(Function<Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String application() {
        return this.application;
    }

    public final List<String> privileges() {
        return this.privileges;
    }

    public final List<String> resources() {
        return this.resources;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("application");
        generator.write(this.application);
        if (ApiTypeHelper.isDefined(this.privileges)) {
            generator.writeKey("privileges");
            generator.writeStartArray();
            for (String item0 : this.privileges) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.resources)) {
            generator.writeKey("resources");
            generator.writeStartArray();
            for (String item0 : this.resources) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupApplicationPrivilegesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::application, JsonpDeserializer.stringDeserializer(), "application");
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "privileges");
        op.add(Builder::resources, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "resources");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ApplicationPrivileges> {
        private String application;
        private List<String> privileges;
        private List<String> resources;

        public final Builder application(String value) {
            this.application = value;
            return this;
        }

        public final Builder privileges(List<String> list) {
            this.privileges = Builder._listAddAll(this.privileges, list);
            return this;
        }

        public final Builder privileges(String value, String ... values) {
            this.privileges = Builder._listAdd(this.privileges, value, values);
            return this;
        }

        public final Builder resources(List<String> list) {
            this.resources = Builder._listAddAll(this.resources, list);
            return this;
        }

        public final Builder resources(String value, String ... values) {
            this.resources = Builder._listAdd(this.resources, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ApplicationPrivileges build() {
            this._checkSingleUse();
            return new ApplicationPrivileges(this);
        }
    }
}

