/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.JobBlockedReason;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JobBlocked
implements JsonpSerializable {
    private final JobBlockedReason reason;
    @Nullable
    private final String taskId;
    public static final JsonpDeserializer<JobBlocked> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobBlocked::setupJobBlockedDeserializer);

    private JobBlocked(Builder builder) {
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.taskId = builder.taskId;
    }

    public static JobBlocked of(Function<Builder, ObjectBuilder<JobBlocked>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final JobBlockedReason reason() {
        return this.reason;
    }

    @Nullable
    public final String taskId() {
        return this.taskId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
        if (this.taskId != null) {
            generator.writeKey("task_id");
            generator.write(this.taskId);
        }
    }

    protected static void setupJobBlockedDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::reason, JobBlockedReason._DESERIALIZER, "reason");
        op.add(Builder::taskId, JsonpDeserializer.stringDeserializer(), "task_id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JobBlocked> {
        private JobBlockedReason reason;
        @Nullable
        private String taskId;

        public final Builder reason(JobBlockedReason value) {
            this.reason = value;
            return this;
        }

        public final Builder taskId(@Nullable String value) {
            this.taskId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JobBlocked build() {
            this._checkSingleUse();
            return new JobBlocked(this);
        }
    }
}

