/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DynamicMapping;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class PropertyBase
implements JsonpSerializable {
    private final Map<String, JsonData> localMetadata;
    private final Map<String, String> meta;
    @Nullable
    private final String name;
    private final Map<String, Property> properties;
    @Nullable
    private final Integer ignoreAbove;
    @Nullable
    private final DynamicMapping dynamic;
    private final Map<String, Property> fields;

    protected PropertyBase(AbstractBuilder<?> builder) {
        this.localMetadata = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).localMetadata);
        this.meta = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).meta);
        this.name = ((AbstractBuilder)builder).name;
        this.properties = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).properties);
        this.ignoreAbove = ((AbstractBuilder)builder).ignoreAbove;
        this.dynamic = ((AbstractBuilder)builder).dynamic;
        this.fields = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
    }

    public final Map<String, JsonData> localMetadata() {
        return this.localMetadata;
    }

    public final Map<String, String> meta() {
        return this.meta;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public final Map<String, Property> properties() {
        return this.properties;
    }

    @Nullable
    public final Integer ignoreAbove() {
        return this.ignoreAbove;
    }

    @Nullable
    public final DynamicMapping dynamic() {
        return this.dynamic;
    }

    public final Map<String, Property> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.localMetadata)) {
            generator.writeKey("local_metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.localMetadata.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreAbove != null) {
            generator.writeKey("ignore_above");
            generator.write(this.ignoreAbove.intValue());
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            this.dynamic.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupPropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::localMetadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "local_metadata");
        op.add(AbstractBuilder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "meta");
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(AbstractBuilder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties");
        op.add(AbstractBuilder::ignoreAbove, JsonpDeserializer.integerDeserializer(), "ignore_above");
        op.add(AbstractBuilder::dynamic, DynamicMapping._DESERIALIZER, "dynamic");
        op.add(AbstractBuilder::fields, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "fields");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Map<String, JsonData> localMetadata;
        @Nullable
        private Map<String, String> meta;
        @Nullable
        private String name;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private Integer ignoreAbove;
        @Nullable
        private DynamicMapping dynamic;
        @Nullable
        private Map<String, Property> fields;

        protected AbstractBuilder() {
        }

        public final BuilderT localMetadata(Map<String, JsonData> map) {
            this.localMetadata = AbstractBuilder._mapPutAll(this.localMetadata, map);
            return (BuilderT)this.self();
        }

        public final BuilderT localMetadata(String key, JsonData value) {
            this.localMetadata = AbstractBuilder._mapPut(this.localMetadata, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT meta(Map<String, String> map) {
            this.meta = AbstractBuilder._mapPutAll(this.meta, map);
            return (BuilderT)this.self();
        }

        public final BuilderT meta(String key, String value) {
            this.meta = AbstractBuilder._mapPut(this.meta, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT name(@Nullable String value) {
            this.name = value;
            return (BuilderT)this.self();
        }

        public final BuilderT properties(Map<String, Property> map) {
            this.properties = AbstractBuilder._mapPutAll(this.properties, map);
            return (BuilderT)this.self();
        }

        public final BuilderT properties(String key, Property value) {
            this.properties = AbstractBuilder._mapPut(this.properties, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(key, fn.apply(new Property.Builder()).build());
        }

        public final BuilderT ignoreAbove(@Nullable Integer value) {
            this.ignoreAbove = value;
            return (BuilderT)this.self();
        }

        public final BuilderT dynamic(@Nullable DynamicMapping value) {
            this.dynamic = value;
            return (BuilderT)this.self();
        }

        public final BuilderT fields(Map<String, Property> map) {
            this.fields = AbstractBuilder._mapPutAll(this.fields, map);
            return (BuilderT)this.self();
        }

        public final BuilderT fields(String key, Property value) {
            this.fields = AbstractBuilder._mapPut(this.fields, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT fields(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.fields(key, fn.apply(new Property.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }
}

