/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.searchable_snapshots.cache_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Shared
implements JsonpSerializable {
    private final long reads;
    private final String bytesReadInBytes;
    private final long writes;
    private final String bytesWrittenInBytes;
    private final long evictions;
    private final int numRegions;
    private final String sizeInBytes;
    private final String regionSizeInBytes;
    public static final JsonpDeserializer<Shared> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Shared::setupSharedDeserializer);

    private Shared(Builder builder) {
        this.reads = ApiTypeHelper.requireNonNull(builder.reads, this, "reads");
        this.bytesReadInBytes = ApiTypeHelper.requireNonNull(builder.bytesReadInBytes, this, "bytesReadInBytes");
        this.writes = ApiTypeHelper.requireNonNull(builder.writes, this, "writes");
        this.bytesWrittenInBytes = ApiTypeHelper.requireNonNull(builder.bytesWrittenInBytes, this, "bytesWrittenInBytes");
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, this, "evictions");
        this.numRegions = ApiTypeHelper.requireNonNull(builder.numRegions, this, "numRegions");
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, this, "sizeInBytes");
        this.regionSizeInBytes = ApiTypeHelper.requireNonNull(builder.regionSizeInBytes, this, "regionSizeInBytes");
    }

    public static Shared of(Function<Builder, ObjectBuilder<Shared>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long reads() {
        return this.reads;
    }

    public final String bytesReadInBytes() {
        return this.bytesReadInBytes;
    }

    public final long writes() {
        return this.writes;
    }

    public final String bytesWrittenInBytes() {
        return this.bytesWrittenInBytes;
    }

    public final long evictions() {
        return this.evictions;
    }

    public final int numRegions() {
        return this.numRegions;
    }

    public final String sizeInBytes() {
        return this.sizeInBytes;
    }

    public final String regionSizeInBytes() {
        return this.regionSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("reads");
        generator.write(this.reads);
        generator.writeKey("bytes_read_in_bytes");
        generator.write(this.bytesReadInBytes);
        generator.writeKey("writes");
        generator.write(this.writes);
        generator.writeKey("bytes_written_in_bytes");
        generator.write(this.bytesWrittenInBytes);
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("num_regions");
        generator.write(this.numRegions);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        generator.writeKey("region_size_in_bytes");
        generator.write(this.regionSizeInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSharedDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::reads, JsonpDeserializer.longDeserializer(), "reads");
        op.add(Builder::bytesReadInBytes, JsonpDeserializer.stringDeserializer(), "bytes_read_in_bytes");
        op.add(Builder::writes, JsonpDeserializer.longDeserializer(), "writes");
        op.add(Builder::bytesWrittenInBytes, JsonpDeserializer.stringDeserializer(), "bytes_written_in_bytes");
        op.add(Builder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(Builder::numRegions, JsonpDeserializer.integerDeserializer(), "num_regions");
        op.add(Builder::sizeInBytes, JsonpDeserializer.stringDeserializer(), "size_in_bytes");
        op.add(Builder::regionSizeInBytes, JsonpDeserializer.stringDeserializer(), "region_size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Shared> {
        private Long reads;
        private String bytesReadInBytes;
        private Long writes;
        private String bytesWrittenInBytes;
        private Long evictions;
        private Integer numRegions;
        private String sizeInBytes;
        private String regionSizeInBytes;

        public final Builder reads(long value) {
            this.reads = value;
            return this;
        }

        public final Builder bytesReadInBytes(String value) {
            this.bytesReadInBytes = value;
            return this;
        }

        public final Builder writes(long value) {
            this.writes = value;
            return this;
        }

        public final Builder bytesWrittenInBytes(String value) {
            this.bytesWrittenInBytes = value;
            return this;
        }

        public final Builder evictions(long value) {
            this.evictions = value;
            return this;
        }

        public final Builder numRegions(int value) {
            this.numRegions = value;
            return this;
        }

        public final Builder sizeInBytes(String value) {
            this.sizeInBytes = value;
            return this;
        }

        public final Builder regionSizeInBytes(String value) {
            this.regionSizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Shared build() {
            this._checkSingleUse();
            return new Shared(this);
        }
    }
}

