/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.EqlFeaturesJoin;
import co.elastic.clients.elasticsearch.xpack.usage.EqlFeaturesKeys;
import co.elastic.clients.elasticsearch.xpack.usage.EqlFeaturesPipes;
import co.elastic.clients.elasticsearch.xpack.usage.EqlFeaturesSequences;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class EqlFeatures
implements JsonpSerializable {
    private final Number join;
    private final EqlFeaturesJoin joins;
    private final EqlFeaturesKeys keys;
    private final Number event;
    private final EqlFeaturesPipes pipes;
    private final Number sequence;
    private final EqlFeaturesSequences sequences;
    public static final JsonpDeserializer<EqlFeatures> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlFeatures::setupEqlFeaturesDeserializer);

    private EqlFeatures(Builder builder) {
        this.join = ApiTypeHelper.requireNonNull(builder.join, this, "join");
        this.joins = ApiTypeHelper.requireNonNull(builder.joins, this, "joins");
        this.keys = ApiTypeHelper.requireNonNull(builder.keys, this, "keys");
        this.event = ApiTypeHelper.requireNonNull(builder.event, this, "event");
        this.pipes = ApiTypeHelper.requireNonNull(builder.pipes, this, "pipes");
        this.sequence = ApiTypeHelper.requireNonNull(builder.sequence, this, "sequence");
        this.sequences = ApiTypeHelper.requireNonNull(builder.sequences, this, "sequences");
    }

    public static EqlFeatures of(Function<Builder, ObjectBuilder<EqlFeatures>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Number join() {
        return this.join;
    }

    public final EqlFeaturesJoin joins() {
        return this.joins;
    }

    public final EqlFeaturesKeys keys() {
        return this.keys;
    }

    public final Number event() {
        return this.event;
    }

    public final EqlFeaturesPipes pipes() {
        return this.pipes;
    }

    public final Number sequence() {
        return this.sequence;
    }

    public final EqlFeaturesSequences sequences() {
        return this.sequences;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("join");
        generator.write(this.join.doubleValue());
        generator.writeKey("joins");
        this.joins.serialize(generator, mapper);
        generator.writeKey("keys");
        this.keys.serialize(generator, mapper);
        generator.writeKey("event");
        generator.write(this.event.doubleValue());
        generator.writeKey("pipes");
        this.pipes.serialize(generator, mapper);
        generator.writeKey("sequence");
        generator.write(this.sequence.doubleValue());
        generator.writeKey("sequences");
        this.sequences.serialize(generator, mapper);
    }

    protected static void setupEqlFeaturesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::join, JsonpDeserializer.numberDeserializer(), "join");
        op.add(Builder::joins, EqlFeaturesJoin._DESERIALIZER, "joins");
        op.add(Builder::keys, EqlFeaturesKeys._DESERIALIZER, "keys");
        op.add(Builder::event, JsonpDeserializer.numberDeserializer(), "event");
        op.add(Builder::pipes, EqlFeaturesPipes._DESERIALIZER, "pipes");
        op.add(Builder::sequence, JsonpDeserializer.numberDeserializer(), "sequence");
        op.add(Builder::sequences, EqlFeaturesSequences._DESERIALIZER, "sequences");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<EqlFeatures> {
        private Number join;
        private EqlFeaturesJoin joins;
        private EqlFeaturesKeys keys;
        private Number event;
        private EqlFeaturesPipes pipes;
        private Number sequence;
        private EqlFeaturesSequences sequences;

        public final Builder join(Number value) {
            this.join = value;
            return this;
        }

        public final Builder joins(EqlFeaturesJoin value) {
            this.joins = value;
            return this;
        }

        public final Builder joins(Function<EqlFeaturesJoin.Builder, ObjectBuilder<EqlFeaturesJoin>> fn) {
            return this.joins(fn.apply(new EqlFeaturesJoin.Builder()).build());
        }

        public final Builder keys(EqlFeaturesKeys value) {
            this.keys = value;
            return this;
        }

        public final Builder keys(Function<EqlFeaturesKeys.Builder, ObjectBuilder<EqlFeaturesKeys>> fn) {
            return this.keys(fn.apply(new EqlFeaturesKeys.Builder()).build());
        }

        public final Builder event(Number value) {
            this.event = value;
            return this;
        }

        public final Builder pipes(EqlFeaturesPipes value) {
            this.pipes = value;
            return this;
        }

        public final Builder pipes(Function<EqlFeaturesPipes.Builder, ObjectBuilder<EqlFeaturesPipes>> fn) {
            return this.pipes(fn.apply(new EqlFeaturesPipes.Builder()).build());
        }

        public final Builder sequence(Number value) {
            this.sequence = value;
            return this;
        }

        public final Builder sequences(EqlFeaturesSequences value) {
            this.sequences = value;
            return this;
        }

        public final Builder sequences(Function<EqlFeaturesSequences.Builder, ObjectBuilder<EqlFeaturesSequences>> fn) {
            return this.sequences(fn.apply(new EqlFeaturesSequences.Builder()).build());
        }

        @Override
        public EqlFeatures build() {
            this._checkSingleUse();
            return new EqlFeatures(this);
        }
    }
}

