/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class AllJobs
implements JsonpSerializable {
    private final int count;
    private final Map<String, Integer> detectors;
    private final Map<String, String> createdBy;
    private final Map<String, Integer> modelSize;
    private final Map<String, Integer> forecasts;
    public static final JsonpDeserializer<AllJobs> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllJobs::setupAllJobsDeserializer);

    private AllJobs(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.detectors = ApiTypeHelper.unmodifiableRequired(builder.detectors, (Object)this, "detectors");
        this.createdBy = ApiTypeHelper.unmodifiableRequired(builder.createdBy, (Object)this, "createdBy");
        this.modelSize = ApiTypeHelper.unmodifiableRequired(builder.modelSize, (Object)this, "modelSize");
        this.forecasts = ApiTypeHelper.unmodifiableRequired(builder.forecasts, (Object)this, "forecasts");
    }

    public static AllJobs of(Function<Builder, ObjectBuilder<AllJobs>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    public final Map<String, Integer> detectors() {
        return this.detectors;
    }

    public final Map<String, String> createdBy() {
        return this.createdBy;
    }

    public final Map<String, Integer> modelSize() {
        return this.modelSize;
    }

    public final Map<String, Integer> forecasts() {
        return this.forecasts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.detectors)) {
            generator.writeKey("detectors");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> entry : this.detectors.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.createdBy)) {
            generator.writeKey("created_by");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.createdBy.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.modelSize)) {
            generator.writeKey("model_size");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.modelSize.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Integer)entry.getValue()).intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.forecasts)) {
            generator.writeKey("forecasts");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.forecasts.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Integer)entry.getValue()).intValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupAllJobsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::detectors, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "detectors");
        op.add(Builder::createdBy, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "created_by");
        op.add(Builder::modelSize, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "model_size");
        op.add(Builder::forecasts, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "forecasts");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AllJobs> {
        private Integer count;
        private Map<String, Integer> detectors;
        private Map<String, String> createdBy;
        private Map<String, Integer> modelSize;
        private Map<String, Integer> forecasts;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder detectors(Map<String, Integer> map) {
            this.detectors = Builder._mapPutAll(this.detectors, map);
            return this;
        }

        public final Builder detectors(String key, Integer value) {
            this.detectors = Builder._mapPut(this.detectors, key, value);
            return this;
        }

        public final Builder createdBy(Map<String, String> map) {
            this.createdBy = Builder._mapPutAll(this.createdBy, map);
            return this;
        }

        public final Builder createdBy(String key, String value) {
            this.createdBy = Builder._mapPut(this.createdBy, key, value);
            return this;
        }

        public final Builder modelSize(Map<String, Integer> map) {
            this.modelSize = Builder._mapPutAll(this.modelSize, map);
            return this;
        }

        public final Builder modelSize(String key, Integer value) {
            this.modelSize = Builder._mapPut(this.modelSize, key, value);
            return this;
        }

        public final Builder forecasts(Map<String, Integer> map) {
            this.forecasts = Builder._mapPutAll(this.forecasts, map);
            return this;
        }

        public final Builder forecasts(String key, Integer value) {
            this.forecasts = Builder._mapPut(this.forecasts, key, value);
            return this;
        }

        @Override
        public AllJobs build() {
            this._checkSingleUse();
            return new AllJobs(this);
        }
    }
}

