/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.rank_eval;

import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalHit;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RankEvalHitItem
implements JsonpSerializable {
    private final RankEvalHit hit;
    @Nullable
    private final Double rating;
    public static final JsonpDeserializer<RankEvalHitItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalHitItem::setupRankEvalHitItemDeserializer);

    private RankEvalHitItem(Builder builder) {
        this.hit = ApiTypeHelper.requireNonNull(builder.hit, this, "hit");
        this.rating = builder.rating;
    }

    public static RankEvalHitItem of(Function<Builder, ObjectBuilder<RankEvalHitItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final RankEvalHit hit() {
        return this.hit;
    }

    @Nullable
    public final Double rating() {
        return this.rating;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("hit");
        this.hit.serialize(generator, mapper);
        if (this.rating != null) {
            generator.writeKey("rating");
            JsonpUtils.serializeDoubleOrNull(generator, this.rating, -2.147483648E9);
        }
    }

    protected static void setupRankEvalHitItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::hit, RankEvalHit._DESERIALIZER, "hit");
        op.add(Builder::rating, JsonpDeserializer.doubleOrNullDeserializer(-2.147483648E9), "rating");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RankEvalHitItem> {
        private RankEvalHit hit;
        @Nullable
        private Double rating;

        public final Builder hit(RankEvalHit value) {
            this.hit = value;
            return this;
        }

        public final Builder hit(Function<RankEvalHit.Builder, ObjectBuilder<RankEvalHit>> fn) {
            return this.hit(fn.apply(new RankEvalHit.Builder()).build());
        }

        public final Builder rating(@Nullable Double value) {
            this.rating = value;
            return this;
        }

        @Override
        public RankEvalHitItem build() {
            this._checkSingleUse();
            return new RankEvalHitItem(this);
        }
    }
}

