/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.CustomAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.DutchAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.FingerprintAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.IcuAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.KeywordAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.KuromojiAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.LanguageAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.NoriAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.PatternAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.SimpleAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.SnowballAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.StandardAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.StopAnalyzer;
import co.elastic.clients.elasticsearch._types.analysis.WhitespaceAnalyzer;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Analyzer
implements TaggedUnion<Kind, AnalyzerVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final AnalyzerVariant _value;
    public static final JsonpDeserializer<Analyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Analyzer::setupAnalyzerDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final AnalyzerVariant _get() {
        return this._value;
    }

    public Analyzer(AnalyzerVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._analyzerKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Analyzer(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static Analyzer of(Function<Builder, ObjectBuilder<Analyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCustom() {
        return this._kind == Kind.Custom;
    }

    public CustomAnalyzer custom() {
        return (CustomAnalyzer)TaggedUnionUtils.get(this, Kind.Custom);
    }

    public boolean isDutch() {
        return this._kind == Kind.Dutch;
    }

    public DutchAnalyzer dutch() {
        return (DutchAnalyzer)TaggedUnionUtils.get(this, Kind.Dutch);
    }

    public boolean isFingerprint() {
        return this._kind == Kind.Fingerprint;
    }

    public FingerprintAnalyzer fingerprint() {
        return (FingerprintAnalyzer)TaggedUnionUtils.get(this, Kind.Fingerprint);
    }

    public boolean isIcuAnalyzer() {
        return this._kind == Kind.IcuAnalyzer;
    }

    public IcuAnalyzer icuAnalyzer() {
        return (IcuAnalyzer)TaggedUnionUtils.get(this, Kind.IcuAnalyzer);
    }

    public boolean isKeyword() {
        return this._kind == Kind.Keyword;
    }

    public KeywordAnalyzer keyword() {
        return (KeywordAnalyzer)TaggedUnionUtils.get(this, Kind.Keyword);
    }

    public boolean isKuromoji() {
        return this._kind == Kind.Kuromoji;
    }

    public KuromojiAnalyzer kuromoji() {
        return (KuromojiAnalyzer)TaggedUnionUtils.get(this, Kind.Kuromoji);
    }

    public boolean isLanguage() {
        return this._kind == Kind.Language;
    }

    public LanguageAnalyzer language() {
        return (LanguageAnalyzer)TaggedUnionUtils.get(this, Kind.Language);
    }

    public boolean isNori() {
        return this._kind == Kind.Nori;
    }

    public NoriAnalyzer nori() {
        return (NoriAnalyzer)TaggedUnionUtils.get(this, Kind.Nori);
    }

    public boolean isPattern() {
        return this._kind == Kind.Pattern;
    }

    public PatternAnalyzer pattern() {
        return (PatternAnalyzer)TaggedUnionUtils.get(this, Kind.Pattern);
    }

    public boolean isSimple() {
        return this._kind == Kind.Simple;
    }

    public SimpleAnalyzer simple() {
        return (SimpleAnalyzer)TaggedUnionUtils.get(this, Kind.Simple);
    }

    public boolean isSnowball() {
        return this._kind == Kind.Snowball;
    }

    public SnowballAnalyzer snowball() {
        return (SnowballAnalyzer)TaggedUnionUtils.get(this, Kind.Snowball);
    }

    public boolean isStandard() {
        return this._kind == Kind.Standard;
    }

    public StandardAnalyzer standard() {
        return (StandardAnalyzer)TaggedUnionUtils.get(this, Kind.Standard);
    }

    public boolean isStop() {
        return this._kind == Kind.Stop;
    }

    public StopAnalyzer stop() {
        return (StopAnalyzer)TaggedUnionUtils.get(this, Kind.Stop);
    }

    public boolean isWhitespace() {
        return this._kind == Kind.Whitespace;
    }

    public WhitespaceAnalyzer whitespace() {
        return (WhitespaceAnalyzer)TaggedUnionUtils.get(this, Kind.Whitespace);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    protected static void setupAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::custom, CustomAnalyzer._DESERIALIZER, "custom");
        op.add(Builder::dutch, DutchAnalyzer._DESERIALIZER, "dutch");
        op.add(Builder::fingerprint, FingerprintAnalyzer._DESERIALIZER, "fingerprint");
        op.add(Builder::icuAnalyzer, IcuAnalyzer._DESERIALIZER, "icu_analyzer");
        op.add(Builder::keyword, KeywordAnalyzer._DESERIALIZER, "keyword");
        op.add(Builder::kuromoji, KuromojiAnalyzer._DESERIALIZER, "kuromoji");
        op.add(Builder::language, LanguageAnalyzer._DESERIALIZER, "language");
        op.add(Builder::nori, NoriAnalyzer._DESERIALIZER, "nori");
        op.add(Builder::pattern, PatternAnalyzer._DESERIALIZER, "pattern");
        op.add(Builder::simple, SimpleAnalyzer._DESERIALIZER, "simple");
        op.add(Builder::snowball, SnowballAnalyzer._DESERIALIZER, "snowball");
        op.add(Builder::standard, StandardAnalyzer._DESERIALIZER, "standard");
        op.add(Builder::stop, StopAnalyzer._DESERIALIZER, "stop");
        op.add(Builder::whitespace, WhitespaceAnalyzer._DESERIALIZER, "whitespace");
        op.setTypeProperty("type", null);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Analyzer> {
        private Kind _kind;
        private AnalyzerVariant _value;

        public ObjectBuilder<Analyzer> custom(CustomAnalyzer v) {
            this._kind = Kind.Custom;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> custom(Function<CustomAnalyzer.Builder, ObjectBuilder<CustomAnalyzer>> fn) {
            return this.custom(fn.apply(new CustomAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> dutch(DutchAnalyzer v) {
            this._kind = Kind.Dutch;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> dutch(Function<DutchAnalyzer.Builder, ObjectBuilder<DutchAnalyzer>> fn) {
            return this.dutch(fn.apply(new DutchAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> fingerprint(FingerprintAnalyzer v) {
            this._kind = Kind.Fingerprint;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> fingerprint(Function<FingerprintAnalyzer.Builder, ObjectBuilder<FingerprintAnalyzer>> fn) {
            return this.fingerprint(fn.apply(new FingerprintAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> icuAnalyzer(IcuAnalyzer v) {
            this._kind = Kind.IcuAnalyzer;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> icuAnalyzer(Function<IcuAnalyzer.Builder, ObjectBuilder<IcuAnalyzer>> fn) {
            return this.icuAnalyzer(fn.apply(new IcuAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> keyword(KeywordAnalyzer v) {
            this._kind = Kind.Keyword;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> keyword(Function<KeywordAnalyzer.Builder, ObjectBuilder<KeywordAnalyzer>> fn) {
            return this.keyword(fn.apply(new KeywordAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> kuromoji(KuromojiAnalyzer v) {
            this._kind = Kind.Kuromoji;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> kuromoji(Function<KuromojiAnalyzer.Builder, ObjectBuilder<KuromojiAnalyzer>> fn) {
            return this.kuromoji(fn.apply(new KuromojiAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> language(LanguageAnalyzer v) {
            this._kind = Kind.Language;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> language(Function<LanguageAnalyzer.Builder, ObjectBuilder<LanguageAnalyzer>> fn) {
            return this.language(fn.apply(new LanguageAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> nori(NoriAnalyzer v) {
            this._kind = Kind.Nori;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> nori(Function<NoriAnalyzer.Builder, ObjectBuilder<NoriAnalyzer>> fn) {
            return this.nori(fn.apply(new NoriAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> pattern(PatternAnalyzer v) {
            this._kind = Kind.Pattern;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> pattern(Function<PatternAnalyzer.Builder, ObjectBuilder<PatternAnalyzer>> fn) {
            return this.pattern(fn.apply(new PatternAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> simple(SimpleAnalyzer v) {
            this._kind = Kind.Simple;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> simple(Function<SimpleAnalyzer.Builder, ObjectBuilder<SimpleAnalyzer>> fn) {
            return this.simple(fn.apply(new SimpleAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> snowball(SnowballAnalyzer v) {
            this._kind = Kind.Snowball;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> snowball(Function<SnowballAnalyzer.Builder, ObjectBuilder<SnowballAnalyzer>> fn) {
            return this.snowball(fn.apply(new SnowballAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> standard(StandardAnalyzer v) {
            this._kind = Kind.Standard;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> standard(Function<StandardAnalyzer.Builder, ObjectBuilder<StandardAnalyzer>> fn) {
            return this.standard(fn.apply(new StandardAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> stop(StopAnalyzer v) {
            this._kind = Kind.Stop;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> stop(Function<StopAnalyzer.Builder, ObjectBuilder<StopAnalyzer>> fn) {
            return this.stop(fn.apply(new StopAnalyzer.Builder()).build());
        }

        public ObjectBuilder<Analyzer> whitespace(WhitespaceAnalyzer v) {
            this._kind = Kind.Whitespace;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Analyzer> whitespace(Function<WhitespaceAnalyzer.Builder, ObjectBuilder<WhitespaceAnalyzer>> fn) {
            return this.whitespace(fn.apply(new WhitespaceAnalyzer.Builder()).build());
        }

        @Override
        public Analyzer build() {
            this._checkSingleUse();
            return new Analyzer(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Custom("custom"),
        Dutch("dutch"),
        Fingerprint("fingerprint"),
        IcuAnalyzer("icu_analyzer"),
        Keyword("keyword"),
        Kuromoji("kuromoji"),
        Language("language"),
        Nori("nori"),
        Pattern("pattern"),
        Simple("simple"),
        Snowball("snowball"),
        Standard("standard"),
        Stop("stop"),
        Whitespace("whitespace");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

