/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Datafeed;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetDatafeedsResponse
implements JsonpSerializable {
    private final long count;
    private final List<Datafeed> datafeeds;
    public static final JsonpDeserializer<GetDatafeedsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetDatafeedsResponse::setupGetDatafeedsResponseDeserializer);

    private GetDatafeedsResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.datafeeds = ApiTypeHelper.unmodifiableRequired(builder.datafeeds, (Object)this, "datafeeds");
    }

    public static GetDatafeedsResponse of(Function<Builder, ObjectBuilder<GetDatafeedsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<Datafeed> datafeeds() {
        return this.datafeeds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.datafeeds)) {
            generator.writeKey("datafeeds");
            generator.writeStartArray();
            for (Datafeed item0 : this.datafeeds) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupGetDatafeedsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::datafeeds, JsonpDeserializer.arrayDeserializer(Datafeed._DESERIALIZER), "datafeeds");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GetDatafeedsResponse> {
        private Long count;
        private List<Datafeed> datafeeds;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder datafeeds(List<Datafeed> list) {
            this.datafeeds = Builder._listAddAll(this.datafeeds, list);
            return this;
        }

        public final Builder datafeeds(Datafeed value, Datafeed ... values) {
            this.datafeeds = Builder._listAdd(this.datafeeds, value, values);
            return this;
        }

        public final Builder datafeeds(Function<Datafeed.Builder, ObjectBuilder<Datafeed>> fn) {
            return this.datafeeds(fn.apply(new Datafeed.Builder()).build(), new Datafeed[0]);
        }

        @Override
        public GetDatafeedsResponse build() {
            this._checkSingleUse();
            return new GetDatafeedsResponse(this);
        }
    }
}

