/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.shard_stores;

import co.elastic.clients.elasticsearch.indices.shard_stores.ShardStore;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ShardStoreWrapper
implements JsonpSerializable {
    private final List<ShardStore> stores;
    public static final JsonpDeserializer<ShardStoreWrapper> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardStoreWrapper::setupShardStoreWrapperDeserializer);

    private ShardStoreWrapper(Builder builder) {
        this.stores = ApiTypeHelper.unmodifiableRequired(builder.stores, (Object)this, "stores");
    }

    public static ShardStoreWrapper of(Function<Builder, ObjectBuilder<ShardStoreWrapper>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ShardStore> stores() {
        return this.stores;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.stores)) {
            generator.writeKey("stores");
            generator.writeStartArray();
            for (ShardStore item0 : this.stores) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupShardStoreWrapperDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::stores, JsonpDeserializer.arrayDeserializer(ShardStore._DESERIALIZER), "stores");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ShardStoreWrapper> {
        private List<ShardStore> stores;

        public final Builder stores(List<ShardStore> list) {
            this.stores = Builder._listAddAll(this.stores, list);
            return this;
        }

        public final Builder stores(ShardStore value, ShardStore ... values) {
            this.stores = Builder._listAdd(this.stores, value, values);
            return this;
        }

        public final Builder stores(Function<ShardStore.Builder, ObjectBuilder<ShardStore>> fn) {
            return this.stores(fn.apply(new ShardStore.Builder()).build(), new ShardStore[0]);
        }

        @Override
        public ShardStoreWrapper build() {
            this._checkSingleUse();
            return new ShardStoreWrapper(this);
        }
    }
}

