/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataPathStats
implements JsonpSerializable {
    private final String available;
    private final long availableInBytes;
    private final String diskQueue;
    private final long diskReads;
    private final String diskReadSize;
    private final long diskReadSizeInBytes;
    private final long diskWrites;
    private final String diskWriteSize;
    private final long diskWriteSizeInBytes;
    private final String free;
    private final long freeInBytes;
    private final String mount;
    private final String path;
    private final String total;
    private final long totalInBytes;
    private final String type;
    public static final JsonpDeserializer<DataPathStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataPathStats::setupDataPathStatsDeserializer);

    private DataPathStats(Builder builder) {
        this.available = ApiTypeHelper.requireNonNull(builder.available, this, "available");
        this.availableInBytes = ApiTypeHelper.requireNonNull(builder.availableInBytes, this, "availableInBytes");
        this.diskQueue = ApiTypeHelper.requireNonNull(builder.diskQueue, this, "diskQueue");
        this.diskReads = ApiTypeHelper.requireNonNull(builder.diskReads, this, "diskReads");
        this.diskReadSize = ApiTypeHelper.requireNonNull(builder.diskReadSize, this, "diskReadSize");
        this.diskReadSizeInBytes = ApiTypeHelper.requireNonNull(builder.diskReadSizeInBytes, this, "diskReadSizeInBytes");
        this.diskWrites = ApiTypeHelper.requireNonNull(builder.diskWrites, this, "diskWrites");
        this.diskWriteSize = ApiTypeHelper.requireNonNull(builder.diskWriteSize, this, "diskWriteSize");
        this.diskWriteSizeInBytes = ApiTypeHelper.requireNonNull(builder.diskWriteSizeInBytes, this, "diskWriteSizeInBytes");
        this.free = ApiTypeHelper.requireNonNull(builder.free, this, "free");
        this.freeInBytes = ApiTypeHelper.requireNonNull(builder.freeInBytes, this, "freeInBytes");
        this.mount = ApiTypeHelper.requireNonNull(builder.mount, this, "mount");
        this.path = ApiTypeHelper.requireNonNull(builder.path, this, "path");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, this, "totalInBytes");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static DataPathStats of(Function<Builder, ObjectBuilder<DataPathStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String available() {
        return this.available;
    }

    public final long availableInBytes() {
        return this.availableInBytes;
    }

    public final String diskQueue() {
        return this.diskQueue;
    }

    public final long diskReads() {
        return this.diskReads;
    }

    public final String diskReadSize() {
        return this.diskReadSize;
    }

    public final long diskReadSizeInBytes() {
        return this.diskReadSizeInBytes;
    }

    public final long diskWrites() {
        return this.diskWrites;
    }

    public final String diskWriteSize() {
        return this.diskWriteSize;
    }

    public final long diskWriteSizeInBytes() {
        return this.diskWriteSizeInBytes;
    }

    public final String free() {
        return this.free;
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    public final String mount() {
        return this.mount;
    }

    public final String path() {
        return this.path;
    }

    public final String total() {
        return this.total;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available");
        generator.write(this.available);
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        generator.writeKey("disk_queue");
        generator.write(this.diskQueue);
        generator.writeKey("disk_reads");
        generator.write(this.diskReads);
        generator.writeKey("disk_read_size");
        generator.write(this.diskReadSize);
        generator.writeKey("disk_read_size_in_bytes");
        generator.write(this.diskReadSizeInBytes);
        generator.writeKey("disk_writes");
        generator.write(this.diskWrites);
        generator.writeKey("disk_write_size");
        generator.write(this.diskWriteSize);
        generator.writeKey("disk_write_size_in_bytes");
        generator.write(this.diskWriteSizeInBytes);
        generator.writeKey("free");
        generator.write(this.free);
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("mount");
        generator.write(this.mount);
        generator.writeKey("path");
        generator.write(this.path);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupDataPathStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::available, JsonpDeserializer.stringDeserializer(), "available");
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes");
        op.add(Builder::diskQueue, JsonpDeserializer.stringDeserializer(), "disk_queue");
        op.add(Builder::diskReads, JsonpDeserializer.longDeserializer(), "disk_reads");
        op.add(Builder::diskReadSize, JsonpDeserializer.stringDeserializer(), "disk_read_size");
        op.add(Builder::diskReadSizeInBytes, JsonpDeserializer.longDeserializer(), "disk_read_size_in_bytes");
        op.add(Builder::diskWrites, JsonpDeserializer.longDeserializer(), "disk_writes");
        op.add(Builder::diskWriteSize, JsonpDeserializer.stringDeserializer(), "disk_write_size");
        op.add(Builder::diskWriteSizeInBytes, JsonpDeserializer.longDeserializer(), "disk_write_size_in_bytes");
        op.add(Builder::free, JsonpDeserializer.stringDeserializer(), "free");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::mount, JsonpDeserializer.stringDeserializer(), "mount");
        op.add(Builder::path, JsonpDeserializer.stringDeserializer(), "path");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataPathStats> {
        private String available;
        private Long availableInBytes;
        private String diskQueue;
        private Long diskReads;
        private String diskReadSize;
        private Long diskReadSizeInBytes;
        private Long diskWrites;
        private String diskWriteSize;
        private Long diskWriteSizeInBytes;
        private String free;
        private Long freeInBytes;
        private String mount;
        private String path;
        private String total;
        private Long totalInBytes;
        private String type;

        public final Builder available(String value) {
            this.available = value;
            return this;
        }

        public final Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        public final Builder diskQueue(String value) {
            this.diskQueue = value;
            return this;
        }

        public final Builder diskReads(long value) {
            this.diskReads = value;
            return this;
        }

        public final Builder diskReadSize(String value) {
            this.diskReadSize = value;
            return this;
        }

        public final Builder diskReadSizeInBytes(long value) {
            this.diskReadSizeInBytes = value;
            return this;
        }

        public final Builder diskWrites(long value) {
            this.diskWrites = value;
            return this;
        }

        public final Builder diskWriteSize(String value) {
            this.diskWriteSize = value;
            return this;
        }

        public final Builder diskWriteSizeInBytes(long value) {
            this.diskWriteSizeInBytes = value;
            return this;
        }

        public final Builder free(String value) {
            this.free = value;
            return this;
        }

        public final Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public final Builder mount(String value) {
            this.mount = value;
            return this;
        }

        public final Builder path(String value) {
            this.path = value;
            return this;
        }

        public final Builder total(String value) {
            this.total = value;
            return this;
        }

        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public DataPathStats build() {
            this._checkSingleUse();
            return new DataPathStats(this);
        }
    }
}

