/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Limits
implements JsonpSerializable {
    @Nullable
    private final String maxModelMemoryLimit;
    private final String effectiveMaxModelMemoryLimit;
    private final String totalMlMemory;
    public static final JsonpDeserializer<Limits> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Limits::setupLimitsDeserializer);

    private Limits(Builder builder) {
        this.maxModelMemoryLimit = builder.maxModelMemoryLimit;
        this.effectiveMaxModelMemoryLimit = ApiTypeHelper.requireNonNull(builder.effectiveMaxModelMemoryLimit, this, "effectiveMaxModelMemoryLimit");
        this.totalMlMemory = ApiTypeHelper.requireNonNull(builder.totalMlMemory, this, "totalMlMemory");
    }

    public static Limits of(Function<Builder, ObjectBuilder<Limits>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String maxModelMemoryLimit() {
        return this.maxModelMemoryLimit;
    }

    public final String effectiveMaxModelMemoryLimit() {
        return this.effectiveMaxModelMemoryLimit;
    }

    public final String totalMlMemory() {
        return this.totalMlMemory;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxModelMemoryLimit != null) {
            generator.writeKey("max_model_memory_limit");
            generator.write(this.maxModelMemoryLimit);
        }
        generator.writeKey("effective_max_model_memory_limit");
        generator.write(this.effectiveMaxModelMemoryLimit);
        generator.writeKey("total_ml_memory");
        generator.write(this.totalMlMemory);
    }

    protected static void setupLimitsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxModelMemoryLimit, JsonpDeserializer.stringDeserializer(), "max_model_memory_limit");
        op.add(Builder::effectiveMaxModelMemoryLimit, JsonpDeserializer.stringDeserializer(), "effective_max_model_memory_limit");
        op.add(Builder::totalMlMemory, JsonpDeserializer.stringDeserializer(), "total_ml_memory");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Limits> {
        @Nullable
        private String maxModelMemoryLimit;
        private String effectiveMaxModelMemoryLimit;
        private String totalMlMemory;

        public final Builder maxModelMemoryLimit(@Nullable String value) {
            this.maxModelMemoryLimit = value;
            return this;
        }

        public final Builder effectiveMaxModelMemoryLimit(String value) {
            this.effectiveMaxModelMemoryLimit = value;
            return this;
        }

        public final Builder totalMlMemory(String value) {
            this.totalMlMemory = value;
            return this;
        }

        @Override
        public Limits build() {
            this._checkSingleUse();
            return new Limits(this);
        }
    }
}

