/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Transport
implements JsonpSerializable {
    private final long rxCount;
    private final String rxSize;
    private final long rxSizeInBytes;
    private final int serverOpen;
    private final long txCount;
    private final String txSize;
    private final long txSizeInBytes;
    public static final JsonpDeserializer<Transport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Transport::setupTransportDeserializer);

    private Transport(Builder builder) {
        this.rxCount = ApiTypeHelper.requireNonNull(builder.rxCount, this, "rxCount");
        this.rxSize = ApiTypeHelper.requireNonNull(builder.rxSize, this, "rxSize");
        this.rxSizeInBytes = ApiTypeHelper.requireNonNull(builder.rxSizeInBytes, this, "rxSizeInBytes");
        this.serverOpen = ApiTypeHelper.requireNonNull(builder.serverOpen, this, "serverOpen");
        this.txCount = ApiTypeHelper.requireNonNull(builder.txCount, this, "txCount");
        this.txSize = ApiTypeHelper.requireNonNull(builder.txSize, this, "txSize");
        this.txSizeInBytes = ApiTypeHelper.requireNonNull(builder.txSizeInBytes, this, "txSizeInBytes");
    }

    public static Transport of(Function<Builder, ObjectBuilder<Transport>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long rxCount() {
        return this.rxCount;
    }

    public final String rxSize() {
        return this.rxSize;
    }

    public final long rxSizeInBytes() {
        return this.rxSizeInBytes;
    }

    public final int serverOpen() {
        return this.serverOpen;
    }

    public final long txCount() {
        return this.txCount;
    }

    public final String txSize() {
        return this.txSize;
    }

    public final long txSizeInBytes() {
        return this.txSizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("rx_count");
        generator.write(this.rxCount);
        generator.writeKey("rx_size");
        generator.write(this.rxSize);
        generator.writeKey("rx_size_in_bytes");
        generator.write(this.rxSizeInBytes);
        generator.writeKey("server_open");
        generator.write(this.serverOpen);
        generator.writeKey("tx_count");
        generator.write(this.txCount);
        generator.writeKey("tx_size");
        generator.write(this.txSize);
        generator.writeKey("tx_size_in_bytes");
        generator.write(this.txSizeInBytes);
    }

    protected static void setupTransportDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rxCount, JsonpDeserializer.longDeserializer(), "rx_count");
        op.add(Builder::rxSize, JsonpDeserializer.stringDeserializer(), "rx_size");
        op.add(Builder::rxSizeInBytes, JsonpDeserializer.longDeserializer(), "rx_size_in_bytes");
        op.add(Builder::serverOpen, JsonpDeserializer.integerDeserializer(), "server_open");
        op.add(Builder::txCount, JsonpDeserializer.longDeserializer(), "tx_count");
        op.add(Builder::txSize, JsonpDeserializer.stringDeserializer(), "tx_size");
        op.add(Builder::txSizeInBytes, JsonpDeserializer.longDeserializer(), "tx_size_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Transport> {
        private Long rxCount;
        private String rxSize;
        private Long rxSizeInBytes;
        private Integer serverOpen;
        private Long txCount;
        private String txSize;
        private Long txSizeInBytes;

        public final Builder rxCount(long value) {
            this.rxCount = value;
            return this;
        }

        public final Builder rxSize(String value) {
            this.rxSize = value;
            return this;
        }

        public final Builder rxSizeInBytes(long value) {
            this.rxSizeInBytes = value;
            return this;
        }

        public final Builder serverOpen(int value) {
            this.serverOpen = value;
            return this;
        }

        public final Builder txCount(long value) {
            this.txCount = value;
            return this;
        }

        public final Builder txSize(String value) {
            this.txSize = value;
            return this;
        }

        public final Builder txSizeInBytes(long value) {
            this.txSizeInBytes = value;
            return this;
        }

        @Override
        public Transport build() {
            this._checkSingleUse();
            return new Transport(this);
        }
    }
}

