/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Counter;
import co.elastic.clients.elasticsearch.xpack.usage.WatcherWatchTrigger;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class WatcherWatch
implements JsonpSerializable {
    private final Map<String, Counter> input;
    @Nullable
    private final Map<String, Counter> condition;
    @Nullable
    private final Map<String, Counter> action;
    private final WatcherWatchTrigger trigger;
    public static final JsonpDeserializer<WatcherWatch> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherWatch::setupWatcherWatchDeserializer, Builder::build);

    public WatcherWatch(Builder builder) {
        this.input = ModelTypeHelper.unmodifiableNonNull(builder.input, "input");
        this.condition = ModelTypeHelper.unmodifiable(builder.condition);
        this.action = ModelTypeHelper.unmodifiable(builder.action);
        this.trigger = Objects.requireNonNull(builder.trigger, "trigger");
    }

    public WatcherWatch(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Counter> input() {
        return this.input;
    }

    @Nullable
    public Map<String, Counter> condition() {
        return this.condition;
    }

    @Nullable
    public Map<String, Counter> action() {
        return this.action;
    }

    public WatcherWatchTrigger trigger() {
        return this.trigger;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("input");
        generator.writeStartObject();
        for (Map.Entry<String, Counter> item0 : this.input.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.condition != null) {
            generator.writeKey("condition");
            generator.writeStartObject();
            for (Map.Entry<String, Counter> item0 : this.condition.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.action != null) {
            generator.writeKey("action");
            generator.writeStartObject();
            for (Map.Entry<String, Counter> item0 : this.action.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("trigger");
        this.trigger.serialize(generator, mapper);
    }

    protected static void setupWatcherWatchDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::input, JsonpDeserializer.stringMapDeserializer(Counter._DESERIALIZER), "input", new String[0]);
        op.add(Builder::condition, JsonpDeserializer.stringMapDeserializer(Counter._DESERIALIZER), "condition", new String[0]);
        op.add(Builder::action, JsonpDeserializer.stringMapDeserializer(Counter._DESERIALIZER), "action", new String[0]);
        op.add(Builder::trigger, WatcherWatchTrigger._DESERIALIZER, "trigger", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<WatcherWatch> {
        private Map<String, Counter> input;
        @Nullable
        private Map<String, Counter> condition;
        @Nullable
        private Map<String, Counter> action;
        private WatcherWatchTrigger trigger;

        public Builder input(Map<String, Counter> value) {
            this.input = value;
            return this;
        }

        public Builder putInput(String key, Counter value) {
            if (this.input == null) {
                this.input = new HashMap<String, Counter>();
            }
            this.input.put(key, value);
            return this;
        }

        public Builder input(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.input(Collections.singletonMap(key, fn.apply(new Counter.Builder()).build()));
        }

        public Builder putInput(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.putInput(key, fn.apply(new Counter.Builder()).build());
        }

        public Builder condition(@Nullable Map<String, Counter> value) {
            this.condition = value;
            return this;
        }

        public Builder putCondition(String key, Counter value) {
            if (this.condition == null) {
                this.condition = new HashMap<String, Counter>();
            }
            this.condition.put(key, value);
            return this;
        }

        public Builder condition(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.condition(Collections.singletonMap(key, fn.apply(new Counter.Builder()).build()));
        }

        public Builder putCondition(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.putCondition(key, fn.apply(new Counter.Builder()).build());
        }

        public Builder action(@Nullable Map<String, Counter> value) {
            this.action = value;
            return this;
        }

        public Builder putAction(String key, Counter value) {
            if (this.action == null) {
                this.action = new HashMap<String, Counter>();
            }
            this.action.put(key, value);
            return this;
        }

        public Builder action(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.action(Collections.singletonMap(key, fn.apply(new Counter.Builder()).build()));
        }

        public Builder putAction(String key, Function<Counter.Builder, ObjectBuilder<Counter>> fn) {
            return this.putAction(key, fn.apply(new Counter.Builder()).build());
        }

        public Builder trigger(WatcherWatchTrigger value) {
            this.trigger = value;
            return this;
        }

        public Builder trigger(Function<WatcherWatchTrigger.Builder, ObjectBuilder<WatcherWatchTrigger>> fn) {
            return this.trigger(fn.apply(new WatcherWatchTrigger.Builder()).build());
        }

        @Override
        public WatcherWatch build() {
            return new WatcherWatch(this);
        }
    }
}

