/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Vector
extends Base {
    private final int denseVectorDimsAvgCount;
    private final int denseVectorFieldsCount;
    @Nullable
    private final Integer sparseVectorFieldsCount;
    public static final JsonpDeserializer<Vector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Vector::setupVectorDeserializer, Builder::build);

    public Vector(Builder builder) {
        super(builder);
        this.denseVectorDimsAvgCount = Objects.requireNonNull(builder.denseVectorDimsAvgCount, "dense_vector_dims_avg_count");
        this.denseVectorFieldsCount = Objects.requireNonNull(builder.denseVectorFieldsCount, "dense_vector_fields_count");
        this.sparseVectorFieldsCount = builder.sparseVectorFieldsCount;
    }

    public Vector(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int denseVectorDimsAvgCount() {
        return this.denseVectorDimsAvgCount;
    }

    public int denseVectorFieldsCount() {
        return this.denseVectorFieldsCount;
    }

    @Nullable
    public Integer sparseVectorFieldsCount() {
        return this.sparseVectorFieldsCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("dense_vector_dims_avg_count");
        generator.write(this.denseVectorDimsAvgCount);
        generator.writeKey("dense_vector_fields_count");
        generator.write(this.denseVectorFieldsCount);
        if (this.sparseVectorFieldsCount != null) {
            generator.writeKey("sparse_vector_fields_count");
            generator.write(this.sparseVectorFieldsCount.intValue());
        }
    }

    protected static void setupVectorDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::denseVectorDimsAvgCount, JsonpDeserializer.integerDeserializer(), "dense_vector_dims_avg_count", new String[0]);
        op.add(Builder::denseVectorFieldsCount, JsonpDeserializer.integerDeserializer(), "dense_vector_fields_count", new String[0]);
        op.add(Builder::sparseVectorFieldsCount, JsonpDeserializer.integerDeserializer(), "sparse_vector_fields_count", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Vector> {
        private Integer denseVectorDimsAvgCount;
        private Integer denseVectorFieldsCount;
        @Nullable
        private Integer sparseVectorFieldsCount;

        public Builder denseVectorDimsAvgCount(int value) {
            this.denseVectorDimsAvgCount = value;
            return this;
        }

        public Builder denseVectorFieldsCount(int value) {
            this.denseVectorFieldsCount = value;
            return this;
        }

        public Builder sparseVectorFieldsCount(@Nullable Integer value) {
            this.sparseVectorFieldsCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Vector build() {
            return new Vector(this);
        }
    }
}

