/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.RealmCache;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Realm
extends Base {
    @Nullable
    private final List<String> name;
    @Nullable
    private final List<Long> order;
    @Nullable
    private final List<Long> size;
    @Nullable
    private final List<RealmCache> cache;
    @Nullable
    private final List<Boolean> hasAuthorizationRealms;
    @Nullable
    private final List<Boolean> hasDefaultUsernamePattern;
    @Nullable
    private final List<Boolean> hasTruststore;
    @Nullable
    private final List<Boolean> isAuthenticationDelegated;
    public static final JsonpDeserializer<Realm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Realm::setupRealmDeserializer, Builder::build);

    public Realm(Builder builder) {
        super(builder);
        this.name = ModelTypeHelper.unmodifiable(builder.name);
        this.order = ModelTypeHelper.unmodifiable(builder.order);
        this.size = ModelTypeHelper.unmodifiable(builder.size);
        this.cache = ModelTypeHelper.unmodifiable(builder.cache);
        this.hasAuthorizationRealms = ModelTypeHelper.unmodifiable(builder.hasAuthorizationRealms);
        this.hasDefaultUsernamePattern = ModelTypeHelper.unmodifiable(builder.hasDefaultUsernamePattern);
        this.hasTruststore = ModelTypeHelper.unmodifiable(builder.hasTruststore);
        this.isAuthenticationDelegated = ModelTypeHelper.unmodifiable(builder.isAuthenticationDelegated);
    }

    public Realm(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> name() {
        return this.name;
    }

    @Nullable
    public List<Long> order() {
        return this.order;
    }

    @Nullable
    public List<Long> size() {
        return this.size;
    }

    @Nullable
    public List<RealmCache> cache() {
        return this.cache;
    }

    @Nullable
    public List<Boolean> hasAuthorizationRealms() {
        return this.hasAuthorizationRealms;
    }

    @Nullable
    public List<Boolean> hasDefaultUsernamePattern() {
        return this.hasDefaultUsernamePattern;
    }

    @Nullable
    public List<Boolean> hasTruststore() {
        return this.hasTruststore;
    }

    @Nullable
    public List<Boolean> isAuthenticationDelegated() {
        return this.isAuthenticationDelegated;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.name != null) {
            generator.writeKey("name");
            generator.writeStartArray();
            for (String string : this.name) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.order != null) {
            generator.writeKey("order");
            generator.writeStartArray();
            for (Long l : this.order) {
                generator.write(l.longValue());
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.writeStartArray();
            for (Long l : this.size) {
                generator.write(l.longValue());
            }
            generator.writeEnd();
        }
        if (this.cache != null) {
            generator.writeKey("cache");
            generator.writeStartArray();
            for (RealmCache realmCache : this.cache) {
                realmCache.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.hasAuthorizationRealms != null) {
            generator.writeKey("has_authorization_realms");
            generator.writeStartArray();
            for (Boolean bl : this.hasAuthorizationRealms) {
                generator.write(bl.booleanValue());
            }
            generator.writeEnd();
        }
        if (this.hasDefaultUsernamePattern != null) {
            generator.writeKey("has_default_username_pattern");
            generator.writeStartArray();
            for (Boolean bl : this.hasDefaultUsernamePattern) {
                generator.write(bl.booleanValue());
            }
            generator.writeEnd();
        }
        if (this.hasTruststore != null) {
            generator.writeKey("has_truststore");
            generator.writeStartArray();
            for (Boolean bl : this.hasTruststore) {
                generator.write(bl.booleanValue());
            }
            generator.writeEnd();
        }
        if (this.isAuthenticationDelegated != null) {
            generator.writeKey("is_authentication_delegated");
            generator.writeStartArray();
            for (Boolean bl : this.isAuthenticationDelegated) {
                generator.write(bl.booleanValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupRealmDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::name, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "name", new String[0]);
        op.add(Builder::order, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.longDeserializer()), "order", new String[0]);
        op.add(Builder::size, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.longDeserializer()), "size", new String[0]);
        op.add(Builder::cache, JsonpDeserializer.arrayDeserializer(RealmCache._DESERIALIZER), "cache", new String[0]);
        op.add(Builder::hasAuthorizationRealms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.booleanDeserializer()), "has_authorization_realms", new String[0]);
        op.add(Builder::hasDefaultUsernamePattern, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.booleanDeserializer()), "has_default_username_pattern", new String[0]);
        op.add(Builder::hasTruststore, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.booleanDeserializer()), "has_truststore", new String[0]);
        op.add(Builder::isAuthenticationDelegated, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.booleanDeserializer()), "is_authentication_delegated", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Realm> {
        @Nullable
        private List<String> name;
        @Nullable
        private List<Long> order;
        @Nullable
        private List<Long> size;
        @Nullable
        private List<RealmCache> cache;
        @Nullable
        private List<Boolean> hasAuthorizationRealms;
        @Nullable
        private List<Boolean> hasDefaultUsernamePattern;
        @Nullable
        private List<Boolean> hasTruststore;
        @Nullable
        private List<Boolean> isAuthenticationDelegated;

        public Builder name(@Nullable List<String> value) {
            this.name = value;
            return this;
        }

        public Builder name(String ... value) {
            this.name = Arrays.asList(value);
            return this;
        }

        public Builder addName(String value) {
            if (this.name == null) {
                this.name = new ArrayList<String>();
            }
            this.name.add(value);
            return this;
        }

        public Builder order(@Nullable List<Long> value) {
            this.order = value;
            return this;
        }

        public Builder order(Long ... value) {
            this.order = Arrays.asList(value);
            return this;
        }

        public Builder addOrder(Long value) {
            if (this.order == null) {
                this.order = new ArrayList<Long>();
            }
            this.order.add(value);
            return this;
        }

        public Builder size(@Nullable List<Long> value) {
            this.size = value;
            return this;
        }

        public Builder size(Long ... value) {
            this.size = Arrays.asList(value);
            return this;
        }

        public Builder addSize(Long value) {
            if (this.size == null) {
                this.size = new ArrayList<Long>();
            }
            this.size.add(value);
            return this;
        }

        public Builder cache(@Nullable List<RealmCache> value) {
            this.cache = value;
            return this;
        }

        public Builder cache(RealmCache ... value) {
            this.cache = Arrays.asList(value);
            return this;
        }

        public Builder addCache(RealmCache value) {
            if (this.cache == null) {
                this.cache = new ArrayList<RealmCache>();
            }
            this.cache.add(value);
            return this;
        }

        public Builder cache(Function<RealmCache.Builder, ObjectBuilder<RealmCache>> fn) {
            return this.cache(fn.apply(new RealmCache.Builder()).build());
        }

        public Builder addCache(Function<RealmCache.Builder, ObjectBuilder<RealmCache>> fn) {
            return this.addCache(fn.apply(new RealmCache.Builder()).build());
        }

        public Builder hasAuthorizationRealms(@Nullable List<Boolean> value) {
            this.hasAuthorizationRealms = value;
            return this;
        }

        public Builder hasAuthorizationRealms(Boolean ... value) {
            this.hasAuthorizationRealms = Arrays.asList(value);
            return this;
        }

        public Builder addHasAuthorizationRealms(Boolean value) {
            if (this.hasAuthorizationRealms == null) {
                this.hasAuthorizationRealms = new ArrayList<Boolean>();
            }
            this.hasAuthorizationRealms.add(value);
            return this;
        }

        public Builder hasDefaultUsernamePattern(@Nullable List<Boolean> value) {
            this.hasDefaultUsernamePattern = value;
            return this;
        }

        public Builder hasDefaultUsernamePattern(Boolean ... value) {
            this.hasDefaultUsernamePattern = Arrays.asList(value);
            return this;
        }

        public Builder addHasDefaultUsernamePattern(Boolean value) {
            if (this.hasDefaultUsernamePattern == null) {
                this.hasDefaultUsernamePattern = new ArrayList<Boolean>();
            }
            this.hasDefaultUsernamePattern.add(value);
            return this;
        }

        public Builder hasTruststore(@Nullable List<Boolean> value) {
            this.hasTruststore = value;
            return this;
        }

        public Builder hasTruststore(Boolean ... value) {
            this.hasTruststore = Arrays.asList(value);
            return this;
        }

        public Builder addHasTruststore(Boolean value) {
            if (this.hasTruststore == null) {
                this.hasTruststore = new ArrayList<Boolean>();
            }
            this.hasTruststore.add(value);
            return this;
        }

        public Builder isAuthenticationDelegated(@Nullable List<Boolean> value) {
            this.isAuthenticationDelegated = value;
            return this;
        }

        public Builder isAuthenticationDelegated(Boolean ... value) {
            this.isAuthenticationDelegated = Arrays.asList(value);
            return this;
        }

        public Builder addIsAuthenticationDelegated(Boolean value) {
            if (this.isAuthenticationDelegated == null) {
                this.isAuthenticationDelegated = new ArrayList<Boolean>();
            }
            this.isAuthenticationDelegated.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Realm build() {
            return new Realm(this);
        }
    }
}

