/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class EqlFeaturesPipes
implements JsonpSerializable {
    private final Number pipeTail;
    private final Number pipeHead;
    public static final JsonpDeserializer<EqlFeaturesPipes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EqlFeaturesPipes::setupEqlFeaturesPipesDeserializer, Builder::build);

    public EqlFeaturesPipes(Builder builder) {
        this.pipeTail = Objects.requireNonNull(builder.pipeTail, "pipe_tail");
        this.pipeHead = Objects.requireNonNull(builder.pipeHead, "pipe_head");
    }

    public EqlFeaturesPipes(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Number pipeTail() {
        return this.pipeTail;
    }

    public Number pipeHead() {
        return this.pipeHead;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pipe_tail");
        generator.write(this.pipeTail.doubleValue());
        generator.writeKey("pipe_head");
        generator.write(this.pipeHead.doubleValue());
    }

    protected static void setupEqlFeaturesPipesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::pipeTail, JsonpDeserializer.numberDeserializer(), "pipe_tail", new String[0]);
        op.add(Builder::pipeHead, JsonpDeserializer.numberDeserializer(), "pipe_head", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<EqlFeaturesPipes> {
        private Number pipeTail;
        private Number pipeHead;

        public Builder pipeTail(Number value) {
            this.pipeTail = value;
            return this;
        }

        public Builder pipeHead(Number value) {
            this.pipeHead = value;
            return this;
        }

        @Override
        public EqlFeaturesPipes build() {
            return new EqlFeaturesPipes(this);
        }
    }
}

