/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.FeatureToggle;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Audit
extends FeatureToggle {
    @Nullable
    private final List<String> outputs;
    public static final JsonpDeserializer<Audit> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Audit::setupAuditDeserializer, Builder::build);

    public Audit(Builder builder) {
        super(builder);
        this.outputs = ModelTypeHelper.unmodifiable(builder.outputs);
    }

    public Audit(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> outputs() {
        return this.outputs;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.outputs != null) {
            generator.writeKey("outputs");
            generator.writeStartArray();
            for (String item0 : this.outputs) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupAuditDeserializer(DelegatingDeserializer<Builder> op) {
        FeatureToggle.setupFeatureToggleDeserializer(op);
        op.add(Builder::outputs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "outputs", new String[0]);
    }

    public static class Builder
    extends FeatureToggle.AbstractBuilder<Builder>
    implements ObjectBuilder<Audit> {
        @Nullable
        private List<String> outputs;

        public Builder outputs(@Nullable List<String> value) {
            this.outputs = value;
            return this;
        }

        public Builder outputs(String ... value) {
            this.outputs = Arrays.asList(value);
            return this;
        }

        public Builder addOutputs(String value) {
            if (this.outputs == null) {
                this.outputs = new ArrayList<String>();
            }
            this.outputs.add(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Audit build() {
            return new Audit(this);
        }
    }
}

