/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.xpack.XpackInfoResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class XpackInfoRequest
extends RequestBase {
    @Nullable
    private final List<String> categories;
    public static final Endpoint<XpackInfoRequest, XpackInfoResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<XpackInfoRequest, XpackInfoResponse>(request -> "GET", request -> "/_xpack", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.categories != null) {
            params.put("categories", request.categories.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, XpackInfoResponse._DESERIALIZER);

    public XpackInfoRequest(Builder builder) {
        this.categories = ModelTypeHelper.unmodifiable(builder.categories);
    }

    public XpackInfoRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> categories() {
        return this.categories;
    }

    public static class Builder
    implements ObjectBuilder<XpackInfoRequest> {
        @Nullable
        private List<String> categories;

        public Builder categories(@Nullable List<String> value) {
            this.categories = value;
            return this;
        }

        public Builder categories(String ... value) {
            this.categories = Arrays.asList(value);
            return this;
        }

        public Builder addCategories(String value) {
            if (this.categories == null) {
                this.categories = new ArrayList<String>();
            }
            this.categories.add(value);
            return this;
        }

        @Override
        public XpackInfoRequest build() {
            return new XpackInfoRequest(this);
        }
    }
}

