/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.watcher.WatcherStatsResponse;
import co.elastic.clients.elasticsearch.watcher.stats.WatcherMetric;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class WatcherStatsRequest
extends RequestBase {
    @Nullable
    private final List<WatcherMetric> metric;
    @Nullable
    private final Boolean emitStacktraces;
    public static final Endpoint<WatcherStatsRequest, WatcherStatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<WatcherStatsRequest, WatcherStatsResponse>(request -> "GET", request -> {
        boolean _metric = true;
        boolean propsSet = false;
        if (request.metric() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v.toString()).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.emitStacktraces != null) {
            params.put("emit_stacktraces", String.valueOf(request.emitStacktraces));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, WatcherStatsResponse._DESERIALIZER);

    public WatcherStatsRequest(Builder builder) {
        this.metric = ModelTypeHelper.unmodifiable(builder.metric);
        this.emitStacktraces = builder.emitStacktraces;
    }

    public WatcherStatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<WatcherMetric> metric() {
        return this.metric;
    }

    @Nullable
    public Boolean emitStacktraces() {
        return this.emitStacktraces;
    }

    public static class Builder
    implements ObjectBuilder<WatcherStatsRequest> {
        @Nullable
        private List<WatcherMetric> metric;
        @Nullable
        private Boolean emitStacktraces;

        public Builder metric(@Nullable List<WatcherMetric> value) {
            this.metric = value;
            return this;
        }

        public Builder metric(WatcherMetric ... value) {
            this.metric = Arrays.asList(value);
            return this;
        }

        public Builder addMetric(WatcherMetric value) {
            if (this.metric == null) {
                this.metric = new ArrayList<WatcherMetric>();
            }
            this.metric.add(value);
            return this;
        }

        public Builder emitStacktraces(@Nullable Boolean value) {
            this.emitStacktraces = value;
            return this;
        }

        @Override
        public WatcherStatsRequest build() {
            return new WatcherStatsRequest(this);
        }
    }
}

