/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.watcher.QueryWatchesResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class QueryWatchesRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final Query query;
    @Nullable
    private final List<JsonValue> sort;
    @Nullable
    private final List<String> searchAfter;
    public static final JsonpDeserializer<QueryWatchesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryWatchesRequest::setupQueryWatchesRequestDeserializer, Builder::build);
    public static final Endpoint<QueryWatchesRequest, QueryWatchesResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<QueryWatchesRequest, QueryWatchesResponse>(request -> "POST", request -> "/_watcher/_query/watches", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, QueryWatchesResponse._DESERIALIZER);

    public QueryWatchesRequest(Builder builder) {
        this.from = builder.from;
        this.size = builder.size;
        this.query = builder.query;
        this.sort = ModelTypeHelper.unmodifiable(builder.sort);
        this.searchAfter = ModelTypeHelper.unmodifiable(builder.searchAfter);
    }

    public QueryWatchesRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Nullable
    public List<JsonValue> sort() {
        return this.sort;
    }

    @Nullable
    public List<String> searchAfter() {
        return this.searchAfter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (JsonValue jsonValue : this.sort) {
                generator.write(jsonValue);
            }
            generator.writeEnd();
        }
        if (this.searchAfter != null) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (String string : this.searchAfter) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryWatchesRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from", new String[0]);
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size", new String[0]);
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonValueDeserializer()), "sort", new String[0]);
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "search_after", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<QueryWatchesRequest> {
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private Query query;
        @Nullable
        private List<JsonValue> sort;
        @Nullable
        private List<String> searchAfter;

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public Builder sort(@Nullable List<JsonValue> value) {
            this.sort = value;
            return this;
        }

        public Builder sort(JsonValue ... value) {
            this.sort = Arrays.asList(value);
            return this;
        }

        public Builder addSort(JsonValue value) {
            if (this.sort == null) {
                this.sort = new ArrayList<JsonValue>();
            }
            this.sort.add(value);
            return this;
        }

        public Builder searchAfter(@Nullable List<String> value) {
            this.searchAfter = value;
            return this;
        }

        public Builder searchAfter(String ... value) {
            this.searchAfter = Arrays.asList(value);
            return this;
        }

        public Builder addSearchAfter(String value) {
            if (this.searchAfter == null) {
                this.searchAfter = new ArrayList<String>();
            }
            this.searchAfter.add(value);
            return this;
        }

        @Override
        public QueryWatchesRequest build() {
            return new QueryWatchesRequest(this);
        }
    }
}

