/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.EmptyTransform;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetTransformResponse
implements JsonpSerializable {
    private final long count;
    private final List<EmptyTransform> transforms;
    public static final JsonpDeserializer<GetTransformResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTransformResponse::setupGetTransformResponseDeserializer, Builder::build);

    public GetTransformResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.transforms = ModelTypeHelper.unmodifiableNonNull(builder.transforms, "transforms");
    }

    public GetTransformResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<EmptyTransform> transforms() {
        return this.transforms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("transforms");
        generator.writeStartArray();
        for (EmptyTransform item0 : this.transforms) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetTransformResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::transforms, JsonpDeserializer.arrayDeserializer(EmptyTransform._DESERIALIZER), "transforms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetTransformResponse> {
        private Long count;
        private List<EmptyTransform> transforms;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder transforms(List<EmptyTransform> value) {
            this.transforms = value;
            return this;
        }

        public Builder transforms(EmptyTransform ... value) {
            this.transforms = Arrays.asList(value);
            return this;
        }

        public Builder addTransforms(EmptyTransform value) {
            if (this.transforms == null) {
                this.transforms = new ArrayList<EmptyTransform>();
            }
            this.transforms.add(value);
            return this;
        }

        public Builder transforms(Function<EmptyTransform.Builder, ObjectBuilder<EmptyTransform>> fn) {
            return this.transforms(fn.apply(new EmptyTransform.Builder()).build());
        }

        public Builder addTransforms(Function<EmptyTransform.Builder, ObjectBuilder<EmptyTransform>> fn) {
            return this.addTransforms(fn.apply(new EmptyTransform.Builder()).build());
        }

        @Override
        public GetTransformResponse build() {
            return new GetTransformResponse(this);
        }
    }
}

