/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch.tasks.Status;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class State
implements JsonpSerializable {
    private final String action;
    private final boolean cancellable;
    @Nullable
    private final String description;
    private final Map<String, List<String>> headers;
    private final long id;
    private final String node;
    @Nullable
    private final String parentTaskId;
    private final long runningTimeInNanos;
    private final long startTimeInMillis;
    @Nullable
    private final Status status;
    private final String type;
    public static final JsonpDeserializer<State> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, State::setupStateDeserializer, Builder::build);

    public State(Builder builder) {
        this.action = Objects.requireNonNull(builder.action, "action");
        this.cancellable = Objects.requireNonNull(builder.cancellable, "cancellable");
        this.description = builder.description;
        this.headers = ModelTypeHelper.unmodifiableNonNull(builder.headers, "headers");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.node = Objects.requireNonNull(builder.node, "node");
        this.parentTaskId = builder.parentTaskId;
        this.runningTimeInNanos = Objects.requireNonNull(builder.runningTimeInNanos, "running_time_in_nanos");
        this.startTimeInMillis = Objects.requireNonNull(builder.startTimeInMillis, "start_time_in_millis");
        this.status = builder.status;
        this.type = Objects.requireNonNull(builder.type, "type");
    }

    public State(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String action() {
        return this.action;
    }

    public boolean cancellable() {
        return this.cancellable;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public long id() {
        return this.id;
    }

    public String node() {
        return this.node;
    }

    @Nullable
    public String parentTaskId() {
        return this.parentTaskId;
    }

    public long runningTimeInNanos() {
        return this.runningTimeInNanos;
    }

    public long startTimeInMillis() {
        return this.startTimeInMillis;
    }

    @Nullable
    public Status status() {
        return this.status;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("cancellable");
        generator.write(this.cancellable);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("headers");
        generator.writeStartObject();
        for (Map.Entry<String, List<String>> item0 : this.headers.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.writeStartArray();
            for (String item1 : item0.getValue()) {
                generator.write(item1);
            }
            generator.writeEnd();
        }
        generator.writeEnd();
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("node");
        generator.write(this.node);
        if (this.parentTaskId != null) {
            generator.writeKey("parent_task_id");
            generator.write(this.parentTaskId);
        }
        generator.writeKey("running_time_in_nanos");
        generator.write(this.runningTimeInNanos);
        generator.writeKey("start_time_in_millis");
        generator.write(this.startTimeInMillis);
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        generator.writeKey("type");
        generator.write(this.type);
    }

    protected static void setupStateDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action", new String[0]);
        op.add(Builder::cancellable, JsonpDeserializer.booleanDeserializer(), "cancellable", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "headers", new String[0]);
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id", new String[0]);
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "node", new String[0]);
        op.add(Builder::parentTaskId, JsonpDeserializer.stringDeserializer(), "parent_task_id", new String[0]);
        op.add(Builder::runningTimeInNanos, JsonpDeserializer.longDeserializer(), "running_time_in_nanos", new String[0]);
        op.add(Builder::startTimeInMillis, JsonpDeserializer.longDeserializer(), "start_time_in_millis", new String[0]);
        op.add(Builder::status, Status._DESERIALIZER, "status", new String[0]);
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<State> {
        private String action;
        private Boolean cancellable;
        @Nullable
        private String description;
        private Map<String, List<String>> headers;
        private Long id;
        private String node;
        @Nullable
        private String parentTaskId;
        private Long runningTimeInNanos;
        private Long startTimeInMillis;
        @Nullable
        private Status status;
        private String type;

        public Builder action(String value) {
            this.action = value;
            return this;
        }

        public Builder cancellable(boolean value) {
            this.cancellable = value;
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder headers(Map<String, List<String>> value) {
            this.headers = value;
            return this;
        }

        public Builder putHeaders(String key, List<String> value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            this.headers.put(key, value);
            return this;
        }

        public Builder id(long value) {
            this.id = value;
            return this;
        }

        public Builder node(String value) {
            this.node = value;
            return this;
        }

        public Builder parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this;
        }

        public Builder runningTimeInNanos(long value) {
            this.runningTimeInNanos = value;
            return this;
        }

        public Builder startTimeInMillis(long value) {
            this.startTimeInMillis = value;
            return this;
        }

        public Builder status(@Nullable Status value) {
            this.status = value;
            return this;
        }

        public Builder status(Function<Status.Builder, ObjectBuilder<Status>> fn) {
            return this.status(fn.apply(new Status.Builder()).build());
        }

        public Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        public State build() {
            return new State(this);
        }
    }
}

